<div class="col-12">

    <div class="col-12">
        <button class="btn btn-dark mb-0" onclick="largeModal('subscriptionsAddForm')">{$lang.datatable.add_subscription}</button>
    </div>

	{include file='main/datatable.tpl' tableTitle="{$lang.datatable.all_subs}"
	theads=["id", {$lang.datatable.name}, {$lang.datatable.duration_days},{$lang.datatable.discount_percent}, {$lang.datatable.discount_sum}, {$lang.datatable.created_at}, {$lang.datatable.actions}]
	data=$subscriptions }

    <div id="subscriptionsAddForm" class="hidden">
        <h5 class="mt-0">{$lang.datatable.add_subscription}:</h5>
        <form method="POST">
            <input type="hidden" name="form_key" value="{$form_key}">
            <div class="row">
                <div class="col-6">
                    <label class="col-form-label mt-1">{$lang.datatable.subs_name}</label>
                    <input type="text" class="form-control" name="name" id="name" required>
                </div>
                <div class="col-6">
                    <label class="col-form-label mt-1">{$lang.datatable.discount_percent}</label>
                    <input type="number" class="form-control" name="discount_percent" id="discount_percent">
                </div>
            </div>

            <div class="row">
                <div class="col-6">
                    <label class="col-form-label mt-1">{$lang.datatable.discount_sum}</label>
                    <input type="number" class="form-control" name="discount_sum" id="discount_sum">
                </div>
                <div class="col-6" style="margin-top: 15px">
                    <label>{$lang.datatable.subs_payment_widget}:</label>
                    <select class="form-select" name="widget_id">
                        {foreach $subscriptionWidgets as $subscriptionWidget}
                            <option value="{$subscriptionWidget.id}">{$subscriptionWidget.name} - {$subscriptionWidget.price} {$config.payment_info.default_currency}</option>
                        {/foreach}
                    </select>
                </div>
                <div class="col-12">
                    <button type="submit" name="create_subscription" class="btn btn-success mt-4" id="submitButton">{$lang.datatable.add}</button>
                </div>
            </div>
        </form>
    </div>


    <div id="subscriptionEditForm" class="hidden">
        <h5 class="mt-0">{$lang.datatable.edit_subscription}:</h5>
        <form method="POST">
            <input type="hidden" name="form_key" value="{$form_key}">
            <input type="hidden" name="subs_id" id="subs_id" value="">
            <div class="row">
                <div class="col-6">
                    <label class="col-form-label mt-1">{$lang.datatable.subs_name}</label>
                    <input type="text" class="form-control" name="name" id="name" required>
                </div>
                <div class="col-6">
                    <label class="col-form-label mt-1">{$lang.datatable.discount_percent}</label>
                    <input type="number" class="form-control" name="discount_percent" id="discount_percent">
                </div>
            </div>

            <div class="row">
                <div class="col-6">
                    <label class="col-form-label mt-1">{$lang.datatable.discount_sum}</label>
                    <input type="number" class="form-control" name="discount_sum" id="discount_sum">
                </div>
                <div class="col-6" style="margin-top: 15px">
                    <label>{$lang.datatable.subs_payment_widget}:</label>
                    <select class="form-select" name="widget_id">
                        {foreach $subscriptionWidgets as $subscriptionWidget}
                            <option value="{$subscriptionWidget.id}">{$subscriptionWidget.name} - {$subscriptionWidget.price} {$config.payment_info.default_currency}</option>
                        {/foreach}
                    </select>
                </div>
                <div class="col-12">
                    <button type="submit" name="edit_subscription" class="btn btn-success mt-4" id="submitButton">{$lang.datatable.edit}</button>
                </div>
            </div>
        </form>
    </div>

    <style>
        .error-field {
            color: red;
            font-size: 13px;
            margin-top: 2px;
        }
    </style>
<script>
    $(document).ready(function () {

        var usersSection = document.getElementById('usersSection');
        usersSection.classList.add('active');
        var usersBlock = document.getElementById('usersBlock');
        usersBlock.classList.add('show');


        $("form").on("submit", function (e) {
            let form = $(this);

            // Удаляем старые ошибки
            form.find(".error-field").remove();

            let nameInput = form.find('[name="name"]');
            let percentInput = form.find('[name="discount_percent"]');
            let sumInput = form.find('[name="discount_sum"]');
            let widgetInput = form.find('[name="widget_id"]');

            let name = nameInput.val().trim();
            let percent = percentInput.val();
            let sum = sumInput.val();
            let widget = widgetInput.val();

            let hasError = false;

            if (!name) {
                nameInput.after('<div class="error-field">Введите название подписки</div>');
                hasError = true;
            }

            if ((percent === "" || percent <= 0) && (sum === "" || sum <= 0)) {
                percentInput.after('<div class="error-field">Укажите процент (>0) или сумму (>0)</div>');
                sumInput.after('<div class="error-field">Укажите процент (>0) или сумму (>0)</div>');
                hasError = true;
            }

            if (!widget || widget === "") {
                widgetInput.after('<div class="error-field">Выберите платежный виджет</div>');
                hasError = true;
            }

            if (hasError) {
                e.preventDefault();
                return false;
            }

         //   $('#subscriptionsAddForm')[0].reset();

        });

        $(".sub_edit").on("click", function () {
            let subscriptionId = $(this).data("id");

            $.ajax({
                url: "engine/ajax/lib/subscription/subscription_data.php",
                dataType: "json",
                type: "POST",
                data: { subscriptionId: subscriptionId },
                success: function (res) {
                    $('#subs_id').val(res.id);
                    $('#subscriptionEditForm [name="name"]').val(res.name);
                    $('#subscriptionEditForm [name="discount_percent"]').val(res.discount_percent);

                    $('#subscriptionEditForm [name="discount_sum"]').val(res.discount_sum);
                    $('#subscriptionEditForm [name="widget_id"]').val(res.widget_id);
                },
                error: function () {

                }
            });
        })


        $("#subscriptions").addClass("active");

    })
</script>
</div>