<div class="tab-pane" id="pills_support_chat" role="tabpanel" aria-labelledby="tab-support">
    <ul class="row list-unstyled li_animate">
        <li class="col-12">
            <style>
                #right-chat {
                    --chat-bg: #fff;
                    --chat-border: #e1e5eb;
                    --chat-primary: #6c5ce7;
                    --chat-text: #2d3436;
                    --chat-text-light: #fff;
                    --chat-bubble-user: #6c5ce7;
                    --chat-bubble-them: #f1f2f6;
                    --chat-hover: #f8f9fa;
                    --chat-radius: 12px;
                }
                #right-chat .nav-pills .nav-link {
                    border-radius: var(--chat-radius);
                    margin-right: 0.5rem;
                    padding: 0.4rem 1rem;
                }

                #right-chat .nav-pills .nav-link.active {
                    background-color: var(--chat-primary);
                    color: var(--chat-text-light);
                }

                #right-chat .tab-content > .tab-pane {
                    margin-top: 0.75rem;
                }
                #right-chat .chat-wrapper {
                    margin: 0 auto;
                    font-family: 'Segoe UI', system-ui, sans-serif;
                }

                #right-chat .chat-container {
                    font-size: 14px;
                    display: flex;
                    flex-direction: column;
                    border: 1px solid var(--chat-border);
                    border-radius: var(--chat-radius);
                    padding: 12px;
                    background: var(--chat-bg);
                    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
                    height: 700px;
                }

                #right-chat .chat-toggle-btn {
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    margin-bottom: 0.5rem;
                    padding: 0.5rem 1rem;
                    background: var(--chat-bg);
                    border: 1px solid var(--chat-border);
                    border-radius: var(--chat-radius);
                    cursor: pointer;
                    transition: all 0.2s;
                }

                #right-chat .chat-toggle-btn:hover {
                    background: var(--chat-hover);
                }

                #right-chat .chat-user-list,
                #right-chat .chat-request-list {
                    max-height: 160px;
                    overflow-y: auto;
                    margin-bottom: 0.75rem;
                    border-radius: var(--chat-radius);
                    border: 1px solid var(--chat-border);
                    background: var(--chat-bg);
                }

                #right-chat .chat-user-list input[type="search"],
                #right-chat .chat-request-list input[type="search"] {
                    width: 100%;
                    border: none;
                    border-bottom: 1px solid var(--chat-border);
                    border-radius: 0;
                    padding: 0.5rem 1rem;
                    margin-bottom: 0.5rem;
                    background: var(--chat-bg);
                }

                #right-chat .chat-user-list input[type="search"]:focus,
                #right-chat .chat-request-list input[type="search"]:focus {
                    outline: none;
                    border-color: var(--chat-primary);
                    box-shadow: 0 2px 0 0 var(--chat-primary);
                }

                #right-chat .chat-user-item {
                    display: flex;
                    align-items: center;
                    padding: 0.75rem;
                    cursor: pointer;
                    transition: background 0.2s;
                    border-bottom: 1px solid var(--chat-border);
                }

                #right-chat .chat-user-item:last-child {
                    border-bottom: none;
                }

                #right-chat .chat-user-item:hover {
                    background: var(--chat-hover);
                }

                #right-chat .chat-user-item.active {
                    background: rgba(108, 92, 231, 0.1);
                }

                #right-chat .chat-user-avatar {
                    width: 40px;
                    height: 40px;
                    border-radius: 50%;
                    object-fit: cover;
                    margin-right: 0.75rem;
                    flex-shrink: 0;
                    background: var(--chat-primary);
                    color: var(--chat-text-light);
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    font-weight: 600;
                }

                #right-chat .chat-user-info {
                    flex-grow: 1;
                    min-width: 0;
                }

                #right-chat .chat-user-name {
                    font-weight: 600;
                    margin-bottom: 0.2rem;
                    white-space: nowrap;
                    overflow: hidden;
                    text-overflow: ellipsis;
                    color: var(--chat-text);
                }

                #right-chat .chat-user-last-message {
                    font-size: 0.85rem;
                    color: var(--chat-text);
                    opacity: 0.7;
                    white-space: nowrap;
                    overflow: hidden;
                    text-overflow: ellipsis;
                }

                #right-chat .chat-user-time {
                    font-size: 0.75rem;
                    color: var(--chat-text);
                    opacity: 0.6;
                    margin-left: 0.5rem;
                    flex-shrink: 0;
                }

                #right-chat .chat-messages {
                    border: 1px solid var(--chat-border);
                    border-radius: var(--chat-radius);
                    padding: 1rem;
                    flex-grow: 1;
                    overflow-y: auto;
                    display: flex;
                    flex-direction: column;
                    gap: 0.75rem;
                    background: var(--chat-bg);
                }

                #right-chat .message {
                    max-width: 75%;
                    padding: 0.75rem 1rem;
                    border-radius: 1rem;
                    word-wrap: break-word;
                    box-shadow: 0 1px 2px rgba(0,0,0,0.1);
                    line-height: 1.4;
                    position: relative;
                }

                #right-chat .message.from-user {
                    align-self: flex-end;
                    background: var(--chat-bubble-user);
                    color: var(--chat-text-light);
                    border-bottom-right-radius: 4px;
                }

                #right-chat .message.from-them {
                    align-self: flex-start;
                    background: var(--chat-bubble-them);
                    color: var(--chat-text);
                    border-bottom-left-radius: 4px;
                }

                #right-chat .message strong {
                    display: block;
                    margin-bottom: 4px;
                    font-weight: 600;
                }

                #right-chat .chat-input-area {
                    margin-top: 0.75rem;
                    display: flex;
                    gap: 0.5rem;
                    align-items: center;
                }

                #right-chat .chat-input-area input[type="text"] {
                    flex-grow: 1;
                    padding: 0.75rem 1rem;
                    border: 1px solid var(--chat-border);
                    border-radius: var(--chat-radius);
                    background: var(--chat-bg);
                }

                #right-chat .chat-input-area input[type="text"]:focus {
                    outline: none;
                    border-color: var(--chat-primary);
                    box-shadow: 0 0 0 2px rgba(108, 92, 231, 0.2);
                }

                #right-chat #sendBtn {
                    padding: 0.75rem 1.5rem;
                    border-radius: var(--chat-radius);
                    background: var(--chat-primary);
                    color: var(--chat-text-light);
                    border: none;
                    cursor: pointer;
                    transition: background 0.2s;
                }

                #right-chat #sendBtn:hover {
                    background: #5a4bc7;
                }

                #right-chat .file-message {
                    font-style: italic;
                    color: var(--chat-text);
                    opacity: 0.8;
                    border-radius: 15px;
                    max-width: 75%;
                    padding: 0.75rem 1rem;
                    background: rgba(0,0,0,0.05);
                }

                #right-chat .accept-user-btn {
                    margin-left: auto;
                    white-space: nowrap;
                }
                #right-chat .badge {
                    font-size: 0.75rem;
                    padding: 0.35em 0.6em;
                }

            </style>

            <div id="right-chat" class="chat-wrapper">
                <div class="chat-container">
                    <!-- Pills navigation -->
                    <ul class="nav nav-pills mb-2" id="chatTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="chat-list-tab" data-bs-toggle="pill" data-bs-target="#chatUserListTab" type="button" role="tab" aria-controls="chatUserListTab" aria-selected="true">
                                Список чатов
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link position-relative" id="chat-request-tab" data-bs-toggle="pill" data-bs-target="#chatRequestListTab" type="button" role="tab" aria-controls="chatRequestListTab" aria-selected="false">
                                Запросы на переписку
                                <span id="requestCountBadge" class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                0
                                <span class="visually-hidden">Новых запросов</span>
                            </span>
                            </button>

                        </li>
                    </ul>

                    <!-- Pills content -->
                    <div class="tab-content" id="chatTabContent">
                        <!-- Tab: Список чатов -->
                        <div class="tab-pane fade show active chat-user-list" id="chatUserListTab" role="tabpanel" aria-labelledby="chat-list-tab">
                            <input type="search" class="form-control form-control-sm mb-2" placeholder="Поиск..." id="chatSearch" />
                            <ul class="list-unstyled mb-0" id="userList"></ul>
                        </div>

                        <!-- Tab: Запросы -->
                        <div class="tab-pane fade chat-request-list" id="chatRequestListTab" role="tabpanel" aria-labelledby="chat-request-tab">
                            <input type="search" class="form-control form-control-sm mb-2" placeholder="Поиск..." id="chatRequestSearch" />
                            <ul class="list-unstyled mb-0" id="requestList"></ul>
                        </div>
                    </div>

                    <!-- Messages -->
                    <div class="chat-messages" id="chatMessages"></div>

                    <!-- Input -->
                    <div class="chat-input-area">
                        <input type="text" id="messageInput" class="form-control form-control-sm" placeholder="Введите сообщение..." />
                        <button class="btn btn-primary btn-sm" id="sendBtn">Отправить</button>
                    </div>
                </div>
            </div>
        </li>
    </ul>
</div>

<script>
    var usersSection = document.getElementById('oaaSection');
    usersSection.classList.add('active');
    var usersBlock = document.getElementById('ordersAndApplications');
    usersBlock.classList.add('show');
    var currentLink = document.getElementById('supportOnlineChat');
    currentLink.classList.add('active');

    window.globalLang = '{$globalLangJson}';
    window.globalLang = JSON.parse(window.globalLang);
</script>
<script src="{$stheme}/js/admin-support-chat.js"></script>