<div class="chart-grid row gap-3">
    <div id="chart-server-status" class="chart-container col-4"></div>
    <div id="chart-errors-logs" class="chart-container col-6"></div>
    <div id="chart-cron-activity" class="chart-container col-4"></div>
    <div id="chart-security" class="chart-container col-6"></div>
    <div id="chart-backups-sync" class="chart-container col-3"></div>
</div>

<script src="https://cdn.jsdelivr.net/npm/apexcharts@3.45.1/dist/apexcharts.min.js"></script>
<script>
    const serverStatusOptions = {
        series: [85],
        chart: {
            type: 'radialBar',
            height: 250,
            toolbar: { show: false }
        },
        plotOptions: {
            radialBar: {
                hollow: {
                    size: '70%'
                },
                dataLabels: {
                    show: true,
                    name: {
                        fontSize: '18px',
                        fontWeight: 'bold',
                        color: '#3e3e3e'
                    },
                    value: {
                        fontSize: '16px',
                        color: '#4CAF50',
                        fontWeight: 'bold'
                    }
                }
            }
        },
        colors: ['#4CAF50'],
        title: {
            text: '1. Состояние сервера',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-server-status"), serverStatusOptions).render();

    const errorsLogsOptions = {
        series: [{
            name: 'Errors',
            data: [5, 8, 12, 20, 15, 18, 25, 30, 10, 8]
        }],
        chart: {
            type: 'bar',
            height: 250,
            toolbar: { show: false }
        },
        plotOptions: {
            bar: {
                horizontal: false,
                columnWidth: '50%',
                endingShape: 'rounded'
            }
        },
        colors: ['#FF5722'],
        xaxis: {
            categories: ['W1', 'W2', 'W3', 'W4', 'W5', 'W6', 'W7', 'W8', 'W9', 'W10']
        },
        title: {
            text: '2. Ошибки и логи',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-errors-logs"), errorsLogsOptions).render();

    const cronActivityOptions = {
        series: [{
            name: 'Cron Jobs',
            data: [10, 15, 12, 18, 20, 22, 24, 30, 35, 40]
        }],
        chart: {
            type: 'line',
            height: 250,
            toolbar: { show: false }
        },
        stroke: {
            width: 3,
            curve: 'smooth'
        },
        colors: ['#2196F3'],
        xaxis: {
            categories: ['W1', 'W2', 'W3', 'W4', 'W5', 'W6', 'W7', 'W8', 'W9', 'W10']
        },
        title: {
            text: '3. Cron-активность',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-cron-activity"), cronActivityOptions).render();

    const securityOptions = {
        series: [{
            name: 'Security Status',
            data: [80, 90, 70, 85, 95]
        }],
        chart: {
            type: 'radar',
            height: 250,
            toolbar: { show: false }
        },
        colors: ['#FF9800'],
        xaxis: {
            categories: ['Firewall', 'Login Attempts', 'Encryption', 'Vulnerability Scans', 'Malware Protection']
        },
        title: {
            text: '4. Безопасность',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-security"), securityOptions).render();

    const backupsSyncOptions = {
        series: [60],
        chart: {
            type: 'radialBar',
            height: 250,
            toolbar: { show: false }
        },
        plotOptions: {
            radialBar: {
                hollow: {
                    size: '70%'
                },
                dataLabels: {
                    show: true,
                    name: {
                        fontSize: '18px',
                        fontWeight: 'bold',
                        color: '#3e3e3e'
                    },
                    value: {
                        fontSize: '16px',
                        color: '#FF9800',
                        fontWeight: 'bold'
                    }
                }
            }
        },
        colors: ['#FF9800'],
        title: {
            text: '5. Бэкапы и синхронизация',
            align: 'left'
        }
    };
    new ApexCharts(document.querySelector("#chart-backups-sync"), backupsSyncOptions).render();

</script>
