{if $access['mnu.create'] || $user.name == 'Demo profile'}

<div class="col-12">
    <button class="btn btn-dark mb-0" onclick="largeModal('userAddForm')">
        {$lang.datatable.add_new_user}
    </button>
</div>

<div class="col-12">
    {include file='main/datatable.tpl'
        tableTitle="{$lang.datatable.users_list}"
        theads=["id", "email", $lang.datatable.group, $lang.datatable.name, $lang.datatable.city, $lang.datatable.sales, $lang.datatable.purchases, $lang.datatable.actions]
        data=$rows
    }
</div>

<!-- ADD USER FORM -->
<div id="userAddForm" class="hidden">
    <h5 class="mt-0">{$lang.datatable.add_new_user}:</h5>
    <form method="POST" enctype="multipart/form-data">
        <div class="row">

            <div class="col-3">
                <label class="col-form-label mt-1">{$lang.datatable.email}</label>
                <input type="email" class="form-control" name="email" id="email_add">
            </div>

            <div class="col-3">
                <label class="col-form-label mt-1">{$lang.tools.password}</label>
                <input type="password" class="form-control" name="password" id="password_add" required>
            </div>

            <div class="col-3">
                <label class="col-form-label mt-1">{$lang.tools.user_name}</label>
                <input type="text" class="form-control" name="name" id="name_add" required>
            </div>

            <div class="col-3">
                <label class="col-form-label mt-1">{$lang.tools.group}</label>
                <select class="form-select form-control" name="group" id="group_add" required>
                    {foreach $groups as $group}
                        <option value="{$group.id}">{$group.name}</option>
                    {/foreach}
                </select>
            </div>

            <div class="col-3">
                <label class="col-form-label mt-1">{$lang.tools.age}</label>
                <input type="text" class="form-control" name="age" id="age_add">
            </div>

            <div class="col-3">
                <label class="col-form-label mt-1">{$lang.tools.phone}</label>
                <input type="tel" class="form-control" name="phone" id="phone_add">
            </div>

            <div class="col-3">
                <label class="col-form-label mt-1">{$lang.tools.city}</label>
                <input type="text" class="form-control" name="city" id="city_add">
            </div>

            <div class="col-3">
                <label class="col-form-label mt-1">{$lang.tools.gender}</label>
                <select class="form-select form-control" name="gender" id="gender_add">
                    <option value="Мужчина" selected>{$lang.tools.male}</option>
                    <option value="Женщина">{$lang.tools.female}</option>
                </select>
            </div>

            <div class="col-6">
                <label class="col-form-label mt-1">{$lang.tools.profile_avatar}</label>
                <input type="file" class="form-control" name="avatar" id="avatar_add" accept="image/*">
            </div>

            <div class="col-6">
                <label class="col-form-label mt-1">{$lang.tools.profile_background}</label>
                <input type="file" class="form-control" name="bg_image" id="bg_image_add" accept="image/*">
            </div>

            <div class="col-12">
                <label class="col-form-label mt-1">{$lang.tools.bio}</label>
                <textarea class="form-control" name="bio" id="bio_add" rows="3"></textarea>
            </div>

            <div class="col-3">
                <button type="submit" name="{if $access['modules.update']}adduser{else}addform{/if}" class="btn btn-success mt-2 mb-2">
                    {$lang.datatable.add}
                </button>
            </div>

        </div>
    </form>
</div>

<!-- EDIT USER MODAL -->
<div class="modal fade" id="editUserModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">Редактировать пользователя</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <form method="POST" enctype="multipart/form-data">
                    <div class="row">

                        <div class="col-3">
                            <label class="col-form-label mt-1">{$lang.datatable.email}</label>
                            <input type="email" class="form-control" id="email_edit" name="email">
                        </div>

                        <div class="col-3">
                            <label class="col-form-label mt-1">{$lang.tools.user_name}</label>
                            <input type="text" class="form-control" id="name_edit" name="name" required>
                        </div>

                        <div class="col-3">
                            <label class="col-form-label mt-1">{$lang.tools.group}</label>
                            <select class="form-select form-control" id="group_edit" name="group" required>
                                {foreach $groups as $group}
                                    <option value="{$group.id}">{$group.name}</option>
                                {/foreach}
                            </select>
                        </div>

                        <div class="col-3">
                            <label class="col-form-label mt-1">{$lang.tools.age}</label>
                            <input type="text" class="form-control" id="age_edit" name="age">
                        </div>

                        <div class="col-3">
                            <label class="col-form-label mt-1">{$lang.tools.phone}</label>
                            <input type="tel" class="form-control" id="phone_edit" name="phone">
                        </div>

                        <div class="col-3">
                            <label class="col-form-label mt-1">{$lang.tools.city}</label>
                            <input type="text" class="form-control" id="city_edit" name="city">
                        </div>

                        <div class="col-3">
                            <label class="col-form-label mt-1">{$lang.tools.gender}</label>
                            <select class="form-select form-control" id="gender_edit" name="gender">
                                <option value="Мужчина">{$lang.tools.male}</option>
                                <option value="Женщина">{$lang.tools.female}</option>
                            </select>
                        </div>

                        <div class="col-6">
                            <label class="col-form-label mt-1">{$lang.tools.profile_avatar}</label>
                            <input type="file" class="form-control" id="avatar_edit" name="avatar" accept="image/*">
                            <input type="hidden" id="user_avatar" name="user_avatar">
                        </div>

                        <div class="col-6">
                            <label class="col-form-label mt-1">{$lang.tools.profile_background}</label>
                            <input type="file" class="form-control" id="bg_image_edit" name="bg_image" accept="image/*">
                            <input type="hidden" id="user_bg_image" name="user_bg_image">
                        </div>

                        <div class="col-12">
                            <label class="col-form-label mt-1">{$lang.tools.bio}</label>
                            <textarea class="form-control" id="bio_edit" name="bio" rows="3"></textarea>
                        </div>

                        <div class="col-3">
                            <button type="submit" name="edituser" class="btn btn-success mt-2 mb-2">
                                {$lang.datatable.edit}
                            </button>
                        </div>

                    </div>
                </form>
            </div>

        </div>
    </div>
</div>

<script src="{$stheme}/js/sections/users.js"></script>

{/if}