<div class="col-12">
    <div id="counterWidgetAddForm">
        <form id="createCounterForm" method="post">
            <h5 class="mt-0">{$lang.datatable.create_counter_widget}:</h5><hr>

            <div class="col-4 mb-2">
                <label for="langSelect">Язык текстовых инпутов виджета</label>
                <select id="langSelect" class="form-select mb-3">
                    {foreach $langs as $langAssoc}
                        <option data-name="{$langAssoc.code}" value="{$langAssoc.code}">
                            {$langAssoc.name}
                        </option>
                    {/foreach}
                </select>
            </div>
            <small>Выбрано <b id="selectedLanguage">Chinese</b></small>

            <div class="tab-content mt-2">
                {foreach $langs as $langAssoc}
                    <div class="tab-pane fade {if $langAssoc@first}show active{/if}"
                         id="{$langAssoc.code}">

                        <div class="col-6 mb-2">
                            <label>{$lang.datatable.widget_name}:</label>
                            <fieldset class="form-icon-group left-icon position-relative">
                                <input type="text" class="form-control" name="translations[{$langAssoc.code}][widget_name]" placeholder="{$lang.datatable.widget_name}">
                                <div class="form-icon position-absolute">
                                    <img src="{$stheme}/images/svg/option.svg" alt="">
                                </div>
                            </fieldset>
                        </div>

                    </div>
                {/foreach}

            </div>
            <div class="row">
                <div class="col-6 mb-2">
                    <label>{$lang.datatable.counter_type}</label>
                    <fieldset class="form-icon-group left-icon position-relative mb-2">
                        <select class="form-select array-select form-control" name="counter_type" required>
                            <option value="from" selected>{$lang.datatable.counter_type1}</option>
                            <option value="to">{$lang.datatable.counter_type2}</option>
                        </select>
                        <div class="form-icon position-absolute">
                            <img src="{$stheme}/images/svg/option.svg" alt="">
                        </div>
                    </fieldset>
                </div>
            </div>
            <div class="row">
                <div class="col-6 mb-2">
                    <label>{$lang.datatable.object_type}:</label>
                    <select class="form-select form-control" name="object_type" id="object_type" required>
                        <option value="modules" selected>{$lang.datatable.modules}</option>
                        <option value="user_groups">{$lang.datatable.users_group}</option>
                    </select>
                </div>

                <div class="col-6 mb-2" id="module_wrapper">
                    <label>{$lang.datatable.module}:</label>
                    <select class="form-select form-control" name="module_name" id="module_name">
                        <option value="" selected>{$lang.datatable.no_use}</option>
                        <option value="all_modules">{$lang.datatable.all_modules}</option>
                        {foreach $activeModules as $module}
                            <option value="{$module}">{$lang.topmenu.$module}</option>
                        {/foreach}
                    </select>
                </div>

                <div class="col-6 mb-2" id="user_group_wrapper" style="display: none;">
                    <label>{$lang.datatable.users_group}:</label>
                    <select class="form-select form-control" name="user_group_name" id="user_group_name">
                        <!-- Пример: динамически заполняемый список групп -->
                        <option value="all_groups">{$lang.datatable.all_groups}</option>
                        {foreach $groups as $group}
                            <option value="{$group.name}">{$group.name}</option>
                        {/foreach}
                    </select>
                </div>

                <div class="col-6 mb-2">
                    <label>{$lang.datatable.why_count}?:</label>
                    <select class="form-select form-control" name="counter_sub_object" id="counter_sub_object">
                        <option value="comments" selected>{$lang.datatable.comments_count}</option>
                        <option value="views">{$lang.datatable.views_count}</option>
                        <option value="all_rows">{$lang.datatable.all_data_count}</option>
                        <option value="category_count">{$lang.datatable.category_count}</option>
                    </select>
                </div>
                <div id="from_count" class="col-3 mb-2">
                    <label>{$lang.datatable.from}:</label>
                    <fieldset class="form-icon-group left-icon position-relative">
                        <input type="number" class="form-control" name="from_count" placeholder="{$lang.datatable.from}">
                        <div class="form-icon position-absolute">
                            <img src="{$stheme}/images/svg/option.svg" alt="">
                        </div>
                    </fieldset>
                </div>

                <div id="to_count" class="col-3 mb-2">
                    <label>{$lang.datatable.to}:</label>
                    <fieldset class="form-icon-group left-icon position-relative">
                        <input type="number" class="form-control" name="to_count" placeholder="{$lang.datatable.to}">
                        <div class="form-icon position-absolute">
                            <img src="{$stheme}/images/svg/option.svg" alt="">
                        </div>
                    </fieldset>
                </div>

                <div class="col-12 col-md-3 mb-2">
                    <label for="active" class="col-form-label">{$lang.datatable.active}:</label>
                    <div class="form-check form-switch">
                        <input type="hidden" name="home_tpl" value="true">
                        <input class="form-check-input offlineswitcher" type="checkbox" role="switch" name="active" id="active" value="true">
                    </div>
                </div>

                <div class="col-6 mb-2" id="template_wrapper">
                    <label>{$lang.datatable.select_template}:</label>
                    <select class="form-select form-control" name="template_name" id="template_name">
                        <option value="auto" selected>{$lang.datatable.auto}</option>
                        {foreach $counterCustomTemplates as $counterCustomTemplate}
                            <option value="{$counterCustomTemplate.name}">{$counterCustomTemplate.name}</option>
                        {/foreach}
                    </select>
                </div>
                <script>
                    document.getElementById('object_type').addEventListener('change', function() {

                        var selectedObjectType = this.value;
                        var counterCreate = document.getElementById("counterWidgetAddForm");

                        var moduleWrapper = counterCreate.querySelector('#module_wrapper');
                        var userGroupWrapper = counterCreate.querySelector('#user_group_wrapper');
                        var counterSelect = counterCreate.querySelector('#counter_sub_object');
                        var from_count = counterCreate.querySelector('#from_count');
                        var to_count = counterCreate.querySelector('#to_count');

                        if (selectedObjectType === 'modules') {
                            // Показываем селектор модуля и скрываем селектор группы пользователей
                            moduleWrapper.style.display = 'block';
                            userGroupWrapper.style.display = 'none';
                            from_count.style.display = 'none';
                            to_count.style.display = 'none';
                            // Изменяем варианты для "Что считать?"
                            counterSelect.innerHTML = `
                <option value="comments" selected>Количество комментариев</option>
                        <option value="views">Количество общих просмотров</option>
                        <option value="all_rows">Количество общих данных</option>
                        <option value="category_count">Количество категорий</option>
            `;
                        } else if (selectedObjectType === 'user_groups') {
                            // Показываем селектор группы пользователей и скрываем селектор модуля
                            moduleWrapper.style.display = 'none';
                            userGroupWrapper.style.display = 'block';
                            from_count.style.display = 'block';
                            to_count.style.display = 'block';

                            // Изменяем варианты для "Что считать?"
                            counterSelect.innerHTML = `
                <option value="user_groups_count" selected>Количество пользователей группы</option>
            `;
                        }
                    });
                </script>
            </div>
            <div class="row">




            </div>
            <div class="row">

            </div><br>
            <button type="submit" name="create-counter" class="btn btn-primary w-100">Создать виджет</button>
        </form>
    </div>
</div>


<script>

    document.getElementById('langSelect').addEventListener('change', function () {
        const value = this.value;
        $("#selectedLanguage").html(value);
        document.querySelectorAll('.tab-pane').forEach(p => {
            p.classList.remove('show', 'active');
        });
        document.getElementById(value).classList.add('show', 'active');
    });

    var wabSection = document.getElementById('wabSection');
    wabSection.classList.add('active');
    var widgetsAndBanners = document.getElementById('widgetsAndBanners');
    widgetsAndBanners.classList.add('show');

    $("#counterWidgets").addClass("active");
</script>