<div class="col-12">
    <div id="counterEdit">
        <h5 class="mt-0">{$lang.datatable.edit_counter_widget}:</h5><hr>
        <form method="post">

            <div class="col-4 mb-2">
                <label for="langSelect">Язык текстовых инпутов виджета</label>
                <select id="langSelect" class="form-select mb-3">
                    {foreach $langs as $langAssoc}
                        <option data-name="{$langAssoc.code}" value="{$langAssoc.code}">
                            {$langAssoc.name}
                        </option>
                    {/foreach}
                </select>
            </div>
            <small>Выбрано <b id="selectedLanguage">Chinese</b></small>


            <div class="tab-content mt-2">
                {foreach $langs as $langAssoc}
                    <div class="tab-pane fade {if $langAssoc@first}show active{/if}"
                         id="{$langAssoc.code}">

                        <div class="col-6 mb-2">
                            <label>{$lang.datatable.widget_name}:</label>
                            <fieldset class="form-icon-group left-icon position-relative">
                                <input type="text" class="form-control" name="translations[{$langAssoc.code}][widget_name]" placeholder="{$lang.datatable.widget_name}">
                                <div class="form-icon position-absolute">
                                    <img src="{$stheme}/images/svg/option.svg" alt="">
                                </div>
                            </fieldset>
                        </div>

                    </div>
                {/foreach}
            </div>

            <div class="row">

                <div class="col-6 mb-2">
                    <label>{$lang.datatable.counter_type}</label>
                    <fieldset class="form-icon-group left-icon position-relative mb-2">
                        <select class="form-select array-select form-control" name="counter_type">
                            <option value="from" selected>{$lang.datatable.counter_type1}</option>
                            <option value="to">{$lang.datatable.counter_type2}</option>
                        </select>
                        <div class="form-icon position-absolute">
                            <img src="{$stheme}/images/svg/option.svg" alt="">
                        </div>
                    </fieldset>
                </div>
            </div>
            <div class="row">
                <div class="col-6 mb-2">
                    <label>{$lang.datatable.object_type}:</label>
                    <select class="form-select form-control" name="object_type_edit" id="object_type_edit">
                        <option value="modules" selected>{$lang.datatable.modules}</option>
                        <option value="user_groups">{$lang.datatable.users_group}</option>
                    </select>
                </div>

                <div class="col-6 mb-2" id="module_wrapper">
                    <label>{$lang.datatable.module}:</label>
                    <select class="form-select form-control" name="module_name" id="module_name">
                        <option value="" selected>{$lang.datatable.no_use}</option>
                        <option value="all_modules">{$lang.datatable.all_modules}</option>
                        {foreach $activeModules as $module}
                            <option value="{$module}">{$lang.topmenu.$module}</option>
                        {/foreach}
                    </select>
                </div>

                <div class="col-6 mb-2" id="user_group_wrapper" style="display: none;">
                    <label>{$lang.datatable.users_group}:</label>
                    <select class="form-select form-control" name="user_group_name" id="user_group_name">
                        <!-- Пример: динамически заполняемый список групп -->
                        <option value="all_groups">{$lang.datatable.all_groups}</option>
                        {foreach $groups as $group}
                            <option value="{$group.name}">{$group.name}</option>
                        {/foreach}
                    </select>
                </div>

                <div class="col-6 mb-2">
                    <label>{$lang.datatable.why_count}?:</label>
                    <select class="form-select form-control" name="counter_sub_object" id="counter_sub_object">
                        <option value="comments" selected>{$lang.datatable.comments_count}</option>
                        <option value="views">{$lang.datatable.views_count}</option>
                        <option value="all_rows">{$lang.datatable.all_data_count}</option>
                        <option value="category_count">{$lang.datatable.category_count}</option>
                    </select>
                </div>
                <div id="from_count" class="col-3 mb-2">
                    <label>{$lang.datatable.from}:</label>
                    <fieldset class="form-icon-group left-icon position-relative">
                        <input type="number" class="form-control" name="from_count" placeholder="{$lang.datatable.from}">
                        <div class="form-icon position-absolute">
                            <img src="{$stheme}/images/svg/option.svg" alt="">
                        </div>
                    </fieldset>
                </div>

                <div id="to_count" class="col-3 mb-2">
                    <label>{$lang.datatable.to}:</label>
                    <fieldset class="form-icon-group left-icon position-relative">
                        <input type="number" class="form-control" name="to_count" placeholder="{$lang.datatable.to}">
                        <div class="form-icon position-absolute">
                            <img src="{$stheme}/images/svg/option.svg" alt="">
                        </div>
                    </fieldset>
                </div>

                <div class="col-12 col-md-3 mb-2">
                    <label for="active" class="col-form-label">{$lang.datatable.active}:</label>
                    <div class="form-check form-switch">
                        <input type="hidden" name="home_tpl" value="true">
                        <input class="form-check-input offlineswitcher" type="checkbox" role="switch" name="active" id="active" value="true">
                    </div>
                </div>
                <div class="col-6 mb-2" id="template_wrapper">
                    <label>{$lang.datatable.select_template}:</label>
                    <select class="form-select form-control" name="template_name" id="template_name">
                        <option value="auto" selected>{$lang.datatable.auto}</option>
                        {foreach $counterCustomTemplates as $counterCustomTemplate}
                            <option value="{$counterCustomTemplate.name}">{$counterCustomTemplate.name}</option>
                        {/foreach}
                    </select>
                </div>

                <script>
                    document.getElementById('object_type_edit').addEventListener('change', function() {
                        var selectedObjectType = this.value;
                        var counterEdit = document.getElementById("counterEdit");

                        var moduleWrapper = counterEdit.querySelector('#module_wrapper');
                        var userGroupWrapper = counterEdit.querySelector('#user_group_wrapper');
                        var counterSelect = counterEdit.querySelector('#counter_sub_object');
                        var from_count = counterEdit.querySelector('#from_count');
                        var to_count = counterEdit.querySelector('#to_count');

                        if (selectedObjectType === 'modules') {
                            // Показываем селектор модуля и скрываем селектор группы пользователей
                            moduleWrapper.style.display = 'block';
                            userGroupWrapper.style.display = 'none';
                            from_count.style.display = 'none';
                            to_count.style.display = 'none';

                            // Изменяем варианты для "Что считать?"
                            counterSelect.innerHTML = `
                 <option value="comments" selected>Количество комментариев</option>
                        <option value="views">Количество общих просмотров</option>
                        <option value="all_rows">Количество общих данных</option>
                        <option value="category_count">Количество категорий</option>
            `;
                        } else if (selectedObjectType === 'user_groups') {
                            // Показываем селектор группы пользователей и скрываем селектор модуля
                            moduleWrapper.style.display = 'none';
                            userGroupWrapper.style.display = 'block';
                            from_count.style.display = 'block';
                            to_count.style.display = 'block';

                            // Изменяем варианты для "Что считать?"
                            counterSelect.innerHTML = `
                <option value="user_groups_count" selected>Количество пользователей группы</option>
            `;
                        }
                    });
                </script>


                {*  <div class="col-6 mb-2">
                      <label>Модуль:</label>
                      <select class="form-select form-control" name="module_name">
                          <option value="" selected>Не использовать</option>
                          {foreach $activeModules as $module}
                              <option value="{$module}">{$lang.topmenu.$module}</option>
                          {/foreach}
                      </select>
                  </div>
                  <div class="col-6 mb-2">
                      <label>Страница:</label>
                      <fieldset class="form-icon-group left-icon position-relative mb-2">
                          <select class="form-select array-select form-control" name="page">
                              <option value="" selected>Не использовать</option>
                              {foreach $staticPages as $staticPage}
                              <option value="{$staticPage.id}"><img src='/engine/lang/{$staticPage.language}/icon.png' style='height: 22px;' alt=''> {$staticPage.title}</option>
                              {/foreach}
                          </select>
                          <div class="form-icon position-absolute">
                              <img src="{$stheme}/images/svg/option.svg" alt="">
                          </div>
                      </fieldset>
                  </div>*}
            </div>
            <div class="row">


            </div>
            <div class="row">

                {*<div class="col-12 col-md-6 mb-2">
                    <label for="disable_delivery" class="col-form-label">Отключить использование дотсавки:</label>
                    <div class="form-check form-switch">
                        <input type="hidden" name="home_tpl" value="false">
                        <input class="form-check-input offlineswitcher" type="checkbox" role="switch" name="disable_delivery" id="disable_delivery" value="true">
                    </div>
                </div>*}
            </div><br>
            <input type="hidden" name="counter_id" value="{$pageId}" id="counter_id">
            <button type="submit" name="edit-counter" class="btn btn-primary w-100">{$lang.datatable.edit}</button>
        </form>
    </div>

</div>

<script>
    const counterId = $("#counter_id").val();

    if (counterId) {
        $.ajax({
            url: 'engine/ajax/lib/counter/get-counter-data.php', // URL обработчика на сервере
            type: 'GET',
            data: { id: counterId },
            dataType: 'json',
            success: function(response) {
                if (response) {
                    var selectedObjectType = response['object_type'];
                    var counterEdit = document.getElementById("counterEdit");

                    var moduleWrapper = counterEdit.querySelector('#module_wrapper');
                    var userGroupWrapper = counterEdit.querySelector('#user_group_wrapper');
                    var counterSelect = counterEdit.querySelector('#counter_sub_object');
                    var from_count = counterEdit.querySelector('#from_count');
                    var to_count = counterEdit.querySelector('#to_count');

                    if (selectedObjectType === 'modules') {
                        // Показываем селектор модуля и скрываем селектор группы пользователей
                        moduleWrapper.style.display = 'block';
                        userGroupWrapper.style.display = 'none';
                        from_count.style.display = 'none';
                        to_count.style.display = 'none';

                        // Изменяем варианты для "Что считать?"
                        counterSelect.innerHTML = `
                    <option value="comments" selected>Количество комментариев</option>
                        <option value="views">Количество общих просмотров</option>
                        <option value="all_rows">Количество общих данных</option>
                        <option value="category_count">Количество категорий</option>
            `;
                    } else if (selectedObjectType === 'user_groups') {
                        // Показываем селектор группы пользователей и скрываем селектор модуля
                        moduleWrapper.style.display = 'none';
                        userGroupWrapper.style.display = 'block';
                        from_count.style.display = 'block';
                        to_count.style.display = 'block';

                        // Изменяем варианты для "Что считать?"
                        counterSelect.innerHTML = `
                <option value="user_groups_count" selected>Количество пользователей группы</option>
            `;
                    }


                    $("#counterEdit").find('input[name="widget_name"]').val("");
                    {literal}
                    response.translations.forEach(function (t) {
                        debugger;
                        let fieldName = `translations[${t.lang_code}][${t.name}]`;

                        $("#counterEdit").find(`[name="${fieldName}"]`).val(t.value);
                    });
                    {/literal}

                    // Заполняем форму полученными данными
                    // $("#counterEdit").find('input[name="widget_name"]').val(response.widget_name);
                    $("#counterEdit").find('select[name="counter_type"]').val(response.counter_type);
                    $("#counterEdit").find('select[name="object_type_edit"]').val(response.object_type).change();
                    $("#counterEdit").find('select[name="template_name"]').val(response.template_name).change();
                    $("#counterEdit").find('select[name="module_name"]').val(response.name);
                    $("#counterEdit").find('select[name="user_group_name"]').val(response.name);
                    $("#counterEdit").find('select[name="counter_sub_object"]').val(response.counter_sub_object);
                    $("#counterEdit").find('input[name="from_count"]').val(response.from_count);
                    $("#counterEdit").find('input[name="to_count"]').val(response.to_count);
                    $("#counterEdit").find('#active').prop('checked', response.active == 1 ? "checked" : "");
                    let active = response.active == 1 ? "true" : "false";
                    $("#counterEdit").find('input[name="active"]').val(active);

                    // Показываем форму редактирования
                } else {
                    alert('Ошибка: ' + response.message);
                }
            },
            error: function() {
                alert('Ошибка запроса.');
            }
        });

    }


    document.getElementById('langSelect').addEventListener('change', function () {
        const value = this.value;
        $("#selectedLanguage").html(value);
        document.querySelectorAll('.tab-pane').forEach(p => {
            p.classList.remove('show', 'active');
        });
        document.getElementById(value).classList.add('show', 'active');
    });
    var wabSection = document.getElementById('wabSection');
    wabSection.classList.add('active');
    var widgetsAndBanners = document.getElementById('widgetsAndBanners');
    widgetsAndBanners.classList.add('show');

    $("#counterWidgets").addClass("active");
</script>