<div class="col-12">
    <div id="createParticipationWidget">
        <h5 class="mt-0">{$lang.datatable.add_participation_widget}:</h5>
        <form method="POST">

            <div class="col-4 mb-2">
                <label for="langSelect">Язык текстовых инпутов виджета</label>
                <select id="langSelect" class="form-select mb-3">
                    {foreach $langs as $langAssoc}
                        <option data-name="{$langAssoc.code}" value="{$langAssoc.code}">
                            {$langAssoc.name}
                        </option>
                    {/foreach}
                </select>
            </div>
            <small>Выбрано <b id="selectedLanguage">Chinese</b></small>

            <input type="hidden" name="form_key" value="{$form_key}">

            <div class="tab-content mt-2">
                {foreach $langs as $langAssoc}
                    <div class="tab-pane fade {if $langAssoc@first}show active{/if}"
                         id="{$langAssoc.code}">
                        <div class="col-6">
                            <label class="col-form-label mt-1" for="name">{$lang.datatable.widget_name}</label>
                            <input type="text" class="form-control" placeholder="{$lang.datatable.widget_name}" name="translations[{$langAssoc.code}][name]" id="translations[{$langAssoc.code}][name]">
                        </div>
                    </div>
                {/foreach}
            </div>
            <div class="row">

                <div class="col-6">
                    <label class="col-form-label mt-1" for="max_user_count">{$lang.datatable.max_users_count}</label>
                    <input type="number" class="form-control" name="max_user_count" id="max_user_count" required>
                </div>
                <div class="col-6">
                    <label class="col-form-label mt-1" for="group_id">{$lang.datatable.from_group}</label>
                    <select class="form-control" id="group_id" name="group_id">
                        {foreach $groups as $groupAssoc}
                            <option value="{$groupAssoc['id']}"> {$groupAssoc['name']} </option>
                        {/foreach}
                    </select>
                </div>
                <div class="col-3">
                    <label class="col-form-label mt-1" for="rgb_first">{$lang.datatable.first_color}</label>
                    <input type="text" class="form-control" name="rgb_first" placeholder="{$lang.datatable.first_color}: #616161" id="rgb_first">
                </div>
                <div class="col-3">
                    <label class="col-form-label mt-1" for="rgb_second">{$lang.datatable.second_color}</label>
                    <input type="text" class="form-control" name="rgb_second" placeholder="{$lang.datatable.second_color}: #859123" id="rgb_second">
                </div>
                <div class="row">
                    <div class="col-6">
                        <label class="col-form-label mt-1" for="parent_widget_id">{$lang.datatable.parent_widget}:</label>
                        <select class="form-control" id="parent_widget_id" name="parent_widget_id">
                            <option selected value=""> {$lang.datatable.excluded_parent_widget} </option>
                            {foreach $participations as $participation}
                                <option value="{$participation['id']}"> {$participation['name']} </option>
                            {/foreach}
                        </select>
                    </div>
                    <div class="col-6" id="template_wrapper">
                        <label>{$lang.datatable.select_template}:</label>
                        <select class="form-control" name="template_name" id="template_name">
                            <option value="auto" selected>{$lang.datatable.auto}</option>
                            {foreach $participationCustomTemplates as $participationCustomTemplate}
                                <option value="{$participationCustomTemplate.name}">{$participationCustomTemplate.name}</option>
                            {/foreach}
                        </select>
                    </div>
                </div>

                <div class="col-12">
                    <button type="submit" name="create_participation" class="btn btn-success mt-4" id="submitButton">{$lang.datatable.add}</button>
                </div>
            </div>
        </form>
    </div>

</div>

<script>
    document.getElementById('langSelect').addEventListener('change', function () {
        const value = this.value;
        $("#selectedLanguage").html(value);
        document.querySelectorAll('.tab-pane').forEach(p => {
            p.classList.remove('show', 'active');
        });
        document.getElementById(value).classList.add('show', 'active');
    });
    var wabSection = document.getElementById('wabSection');
    wabSection.classList.add('active');
    var widgetsAndBanners = document.getElementById('widgetsAndBanners');
    widgetsAndBanners.classList.add('show');

    $("#participationWidgets").addClass("active");
</script>