<div class="col-12">
    <div id="quizWidgetAddForm">
        <form id="createQuizForm" method="post" enctype="multipart/form-data">

            <input type="hidden" name="form_key" value="{$form_key}">

            <h5 class="mt-0">{$lang.datatable.create_quiz_widget}:</h5><hr>

            <div class="col-4 mb-2">
                <label for="langSelect">Язык текстовых инпутов виджета</label>
                <select id="langSelect" class="form-select mb-3">
                    {foreach $langs as $langAssoc}
                        <option data-name="{$langAssoc.code}" value="{$langAssoc.code}">
                            {$langAssoc.name}
                        </option>
                    {/foreach}
                </select>
            </div>
            <small>Выбрано <b id="selectedLanguage">Chinese</b></small>


            <div class="tab-content mt-2">
                {foreach $langs as $langAssoc}
                    <div class="tab-pane fade {if $langAssoc@first}show active{/if}"
                         id="{$langAssoc.code}">
                        <div class="col-6 mb-2">
                            <label>{$lang.datatable.widget_name}:</label>
                            <fieldset class="form-icon-group left-icon position-relative">
                                <input type="text" class="form-control" name="translations[{$langAssoc.code}][main_title]" placeholder="{$lang.datatable.widget_name}">
                                <div class="form-icon position-absolute">
                                    <img src="{$stheme}/images/svg/option.svg" alt="">
                                </div>
                            </fieldset>
                        </div>
                    </div>
                {/foreach}
            </div>
            <div class="col-6 mb-2">
                <label>{$lang.datatable.quiz_type}</label>
                <fieldset class="form-icon-group left-icon position-relative mb-2">
                    <select class="form-select array-select form-control" id="quiz_type" name="quiz_type">
                        <option value="pay">{$lang.datatable.payed_quiz}</option>
                        <option value="free" selected>{$lang.datatable.free_quiz}</option>
                    </select>
                    <div class="form-icon position-absolute">
                        <img src="{$stheme}/images/svg/option.svg" alt="">
                    </div>
                </fieldset>
            </div>
            <div class="row">
                <div class="col-6 mb-2">
                    <label>{$lang.datatable.counter}</label>
                    <fieldset class="form-icon-group left-icon position-relative mb-2">
                        <select class="form-select array-select form-control" data-original-title="by_country" id="by_country" name="type">
                            <option value="true">{$lang.datatable.by_country}</option>
                            <option value="false" selected>{$lang.datatable.by_default}</option>
                        </select>
                        <div class="form-icon position-absolute">
                            <img src="{$stheme}/images/svg/option.svg" alt="">
                        </div>
                    </fieldset>
                </div>
                <div class="col-6 mb-2" id="template_wrapper">
                    <label>{$lang.datatable.select_template}:</label>
                    <select class="form-select form-control" name="template_name" id="template_name">
                        <option value="auto" selected>{$lang.datatable.auto}</option>
                        {foreach $quizCustomTemplates as $quizCustomTemplate}
                            <option value="{$quizCustomTemplate.name}">{$quizCustomTemplate.name}</option>
                        {/foreach}
                    </select>
                </div>
                <div class="col-6 mb-2" id="price_input" style="display: none">
                    <label>{$lang.datatable.price}:</label>
                    <fieldset class="form-icon-group left-icon position-relative">
                        <input type="number" class="form-control" name="price" placeholder="{$lang.datatable.price}">
                        <div class="form-icon position-absolute">
                            <img src="{$stheme}/images/svg/option.svg" alt="">
                        </div>
                    </fieldset>
                </div>
            </div>
            <div class="row">
                <div class="container">
                    <h2 class="mb-3">{$lang.datatable.quiz_creating}</h2>
                    <div id="questions">
                    </div>
                    <button id="add-question" type="button" class="btn btn-success mt-3">+ {$lang.datatable.add_quiz}</button>
                </div>



            </div><br>
            <button type="submit" name="create-quiz" class="btn btn-primary w-100">{$lang.datatable.add}</button>
        </form>
    </div>

</div>

<script>
    $(document).ready(function() {

        let questionIndex = 0;

        $('#add-question').click(function() {
            questionIndex++;
            {literal}
            $('#questions').append(`
                    <div class="question-block border p-3 mb-3" data-question-index="${questionIndex}">
                        <div class="mb-3">
                            <label class="form-label">Вопрос</label>
                            <input type="text" class="form-control" name="questions[${questionIndex}]" placeholder="Введите ваш вопрос">
                        </div>
                        <div class="answers">
                            <div class="d-flex align-items-center answer-input">
                                <input type="text" class="form-control" name="answers[${questionIndex}][]" placeholder="Вариант ответа">
                                <span class="ms-2 remove-answer">&times;</span>
                            </div>
                        </div>
                        <button class="add-answer btn btn-outline-primary mt-2" type="button">+ Добавить ответ</button>
                        <span class="ms-3 remove-question">Удалить вопрос</span>

                        <div class="mt-4">
                            <label class="form-label">Загрузите изображение</label>
                            <div class="custom-file-input">
                                <input type="file" id="imageUpload_${questionIndex}" name="question_images[${questionIndex}][]" accept="image/*">
                                <div class="custom-file-label custom-file-label_${questionIndex}">Нажмите для загрузки изображения</div>
                            </div>
                        </div>
                    </div>


                `);

            $('#imageUpload_'+questionIndex).change(function(event) {
                let fileName = event.target.files[0] ? event.target.files[0].name : "Нажмите для загрузки изображения";
                $('.custom-file-label_'+questionIndex).text(fileName);
            });
        });

        $(document).on('click', '.add-answer', function() {
            let questionBlock = $(this).closest('.question-block');
            let qIndex = questionBlock.data('question-index');
            questionBlock.find('.answers').append(`
                    <div class="d-flex align-items-center answer-input">
                        <input type="text" class="form-control" name="answers[${qIndex}][]" placeholder="Вариант ответа">
                        <span class="ms-2 remove-answer">&times;</span>
                    </div>
                `);
        });
        {/literal}

        document.getElementById('quiz_type').addEventListener('change', function() {
            var selectedObjectType = this.value;
            var widgetCreate = document.getElementById("quizWidgetAddForm");
            //var widgetEdit = document.getElementById("widgetEditForm");

            var priceInput = widgetCreate.querySelector('#price_input');

            if (selectedObjectType == "pay") {
                priceInput.style.display = "block";
            } else {
                priceInput.style.display = "none";
            }

        });

        $(document).on('click', '.remove-answer', function() {
            $(this).parent().remove();
        });

        $(document).on('click', '.remove-question', function() {
            $(this).closest('.question-block').remove();
        });
        document.getElementById('langSelect').addEventListener('change', function () {
            const value = this.value;
            $("#selectedLanguage").html(value);
            document.querySelectorAll('.tab-pane').forEach(p => {
                p.classList.remove('show', 'active');
            });
            document.getElementById(value).classList.add('show', 'active');
        });

        var wabSection = document.getElementById('wabSection');
        wabSection.classList.add('active');
        var widgetsAndBanners = document.getElementById('widgetsAndBanners');
        widgetsAndBanners.classList.add('show');

        $("#quizWidgets").addClass("active");
    });
</script>

<style>
    .answer-input { margin-bottom: 5px; }
    .remove-answer { cursor: pointer; color: red; }

    .custom-file-input {
        position: relative;
        display: inline-block;
        width: 100%;
        height: 45px;
        overflow: hidden;
    }
    .custom-file-input input {
        position: absolute;
        left: 0;
        top: 0;
        opacity: 0;
        width: 100%;
        height: 100%;
        cursor: pointer;
    }
    .custom-file-label {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        height: 100%;
        background: #f8f9fa;
        border: 2px dashed #6c757d;
        border-radius: 5px;
        color: #6c757d;
        font-weight: 500;
        transition: background 0.3s;
    }
    .custom-file-input:hover .custom-file-label {
        background: #e9ecef;
    }
</style>
