{if isset($resultMessage)}
    <div class="alert alert-success">
        {$resultMessage}
    </div>
{/if}

<div class="col-12">
    <button class="btn btn-dark mb-0" onclick="largeModal('widgetAddForm')">Добавить слайдер</button>
</div>

<div class="col-12">
	<table class="table">
		<thead>
			<tr>
				<th class="border-end text-center" width="50px">#</th>
				<th class="border-end">title</th>
				<th class="border-end text-center" width="100px">social</th>
				<th class="border-end text-center" width="100px">token</th>
				<th class="border-end text-center" width="100px">resource</th>
				<th class="border-end text-center" width="100px">rows</th>
				<th class="border-end text-center" width="100px">columns</th>
				<th class="border-end text-center" width="200px">created_at</th>
				<th class="text-center" width="100px">action</th>
			</tr>
		</thead>
		<tbody>
			{foreach from=$sliders item=slider}
			<tr>
				<td class="border-end text-center">{$slider.id}</td>
				<td class="border-end">{$slider.title}</td>
				<td class="border-end text-center">{$slider.social}</td>
				<td class="border-end text-center">{$slider.token|truncate:10:"..."}</td>
				<td class="border-end text-center">{$slider.resource}</td>
				<td class="border-end text-center">{$slider.rows}</td>
				<td class="border-end text-center">{$slider.columns}</td>
				<td class="border-end text-center">{$slider.created_at}</td>
				<td class="text-center">
					<form method="POST" action="/admin?action=socialwidgets" style="display:inline;">
						<input type="hidden" name="form_key" value="{$form_key}">
						<input type="hidden" name="delete_slider" value="{$slider.id}">
						<button type="submit" class="no-b mx-1" onclick="return confirm('Вы уверены, что хотите удалить слайдер?');">
							<i class="fa fa-trash"></i>
						</button>
					</form>
				</td>
			</tr>
			{/foreach}
		</tbody>
	</table>	
</div>

<div id="widgetAddForm" class="hidden">
    <h5 class="mt-0">Создать социальный слайдер:</h5>
    <form method="post">
        <input type="hidden" name="form_key" value="{$form_key}">
        <div class="row">
            <div class="col-4 mb-2">
                <label>Дата:</label>
                <fieldset class="form-icon-group left-icon position-relative mb-2">
                    <input type="datetime-local" class="form-control" name="date">
                    <div class="form-icon position-absolute">
                        <img src="{$stheme}/images/svg/option.svg" alt="">
                    </div>
                </fieldset>
            </div>
            <div class="col-4 mb-2">
                <label>Рядов:</label>
                <fieldset class="form-icon-group left-icon position-relative mb-2">
                    <select class="form-select array-select form-control" name="rows">
                        <option value="1">1</option>
                        <option value="2">2</option>
                        <option value="3">3</option>
                        <option value="4">4</option>
                        <option value="5">5</option>
                        <option value="6">6</option>
                        <option value="7">7</option>
                        <option value="8">8</option>
                    </select>
                    <div class="form-icon position-absolute">
                        <img src="{$stheme}/images/svg/option.svg" alt="">
                    </div>
                </fieldset>
            </div>
            <div class="col-4 mb-2">
                <label>Столбцов:</label>
                <fieldset class="form-icon-group left-icon position-relative mb-2">
                    <select class="form-select array-select form-control" name="columns">
                        <option value="1">1</option>
                        <option value="2">2</option>
                        <option value="3">3</option>
                        <option value="4">4</option>
                        <option value="5">5</option>
                        <option value="6">6</option>
                        <option value="7">7</option>
                        <option value="8">8</option>
                    </select>
                    <div class="form-icon position-absolute">
                        <img src="{$stheme}/images/svg/option.svg" alt="">
                    </div>
                </fieldset>
            </div>
            <div class="col-8 mb-2">
                <label>Название слайдера:</label>
                <fieldset class="form-icon-group left-icon position-relative">
                    <input type="text" class="form-control" name="title" placeholder="Например: реклама">
                    <div class="form-icon position-absolute">
                        <img src="{$stheme}/images/svg/option.svg" alt="">
                    </div>
                </fieldset>
            </div>
            <div class="col-4 mb-2">
                <label>Социальная сеть:</label>
                <fieldset class="form-icon-group left-icon position-relative mb-2">
                    <select class="form-select array-select form-control" name="social">
                        <option value="instagram">Instagram</option>
                        <option value="facebook">Facebook</option>
                    </select>
                    <div class="form-icon position-absolute">
                        <img src="{$stheme}/images/svg/option.svg" alt="">
                    </div>
                </fieldset>
            </div>
            <div class="col-12 mb-2">
                <label>Ресурс (ID страницы или аккаунта):</label>
                <fieldset class="form-icon-group left-icon position-relative mb-2">
                    <input type="text" class="form-control" name="resource">
                    <div class="form-icon position-absolute">
                        <img src="{$stheme}/images/svg/option.svg" alt="">
                    </div>
                </fieldset>
            </div>
            <div class="col-12 mb-2">
                <label>API-токен (уникальный ключ для доступа к данным пользователя):</label>
                <fieldset class="form-icon-group left-icon position-relative mb-2">
                    <input type="text" class="form-control" name="token">
                    <div class="form-icon position-absolute">
                        <img src="{$stheme}/images/svg/option.svg" alt="">
                    </div>
                </fieldset>
            </div>
        </div>
        <button type="submit" name="add_slider" class="btn btn-primary w-100">Создать виджет</button>
    </form>
</div>

<script>
	var wabSection = document.getElementById('wabSection');
	wabSection.classList.add('active');
	var widgetsAndBanners = document.getElementById('widgetsAndBanners');
	widgetsAndBanners.classList.add('show');
	var currentLink = document.getElementById('socialWidgets');
	currentLink.classList.add('active');
</script>