<div class="col-12">
    <div id="editWallWidget">
        <h5 class="mt-0">{$lang.datatable.edit_wall_widget}:</h5>
        <form method="POST">
            <div class="col-4 mb-2">
                <label for="langSelect">Язык текстовых инпутов виджета</label>
                <select id="langSelect" class="form-select mb-3">
                    {foreach $langs as $langAssoc}
                        <option data-name="{$langAssoc.code}" value="{$langAssoc.code}">
                            {$langAssoc.name}
                        </option>
                    {/foreach}
                </select>
            </div>
            <small>Выбрано <b id="selectedLanguage">Chinese</b></small>

            <input type="hidden" name="form_key" value="{$form_key}">

            <div class="tab-content mt-2">
                {foreach $langs as $langAssoc}
                    <div class="tab-pane fade {if $langAssoc@first}show active{/if}"
                         id="{$langAssoc.code}">
                        <div class="col-6">
                            <label class="col-form-label mt-1" for="title">{$lang.datatable.title}</label>
                            <input type="text" class="form-control" placeholder="{$lang.datatable.title}" name="translations[{$langAssoc.code}][title]" id="title">
                        </div>
                        <div class="col-12">
                            <label class="col-form-label mt-1" for="description">{$lang.datatable.description}</label>
                            <textarea class="form-control" name="translations[{$langAssoc.code}][description]" id="description"></textarea>
                        </div>
                    </div>
                {/foreach}
            </div><br>

            <div class="row">
                <input type="hidden" class="form-control" name="id" id="wall-id" value="{$pageId}" required>


                <div class="col-6" id="template_wrapper">
                    <label for="template_name">{$lang.datatable.select_template}:</label>
                    <select class="form-control" name="template_name" id="template_name">
                        {foreach $wallsCustomTemplates as $wallCustomTemplates}
                            <option value="{$wallCustomTemplates.name}">{$wallCustomTemplates.name}</option>
                        {/foreach}
                    </select>
                </div>
            </div>
            <div class="row">

                <div class="col-6">
                    <label class="col-form-label mt-1" for="visibility_type">{$lang.datatable.visibility_type}</label>
                    <select class="form-control" id="visibility_type" name="visibility_type">
                        <option value="1">Public</option>
                        <option value="2">Private</option>
                        <option value="3">Restricted</option>
                    </select>
                </div>
                <div class="col-6">
                    <label class="col-form-label mt-1" for="posting_access_type">{$lang.datatable.posting_access_type}</label>
                    <select class="form-control" id="posting_access_type" name="posting_access_type">
                        <option value="1">All</option>
                        <option value="2">Followers</option>
                        <option value="3">Owner Only</option>
                    </select>
                </div>
            </div>
            <div class="row">

            </div>
            <div class="col-12">
                <button type="submit" name="edit_wall" class="btn btn-success mt-4" id="submitButton">{$lang.datatable.edit}</button>
            </div>
        </form>

    </div>

</div>

<script>
    $(document).ready(function() {

        const dataId = $("#wall-id").val();

        if (dataId) {
            $.ajax({
                url: 'engine/ajax/lib/wall/get_wall_data.php',
                type: 'GET',
                data: {
                    id: dataId
                },
                dataType: 'json',
                success: function (response) {
                    if (response) {
                        var editWallWidget = $("#editWallWidget");

                        $("#wall-id").val(response.id);

                        editWallWidget.find('input[name="title"]').val("");
                        editWallWidget.find('input[name="description"]').val("");

                        {literal}
                        response.translations.forEach(function (t) {
                            let fieldName = `translations[${t.lang_code}][${t.name}]`;

                            editWallWidget.find(`[name="${fieldName}"]`).val(t.value);
                        });
                        {/literal}

                        //editWallWidget.find('input[name="title"]').val(response.title);
                        //editWallWidget.find('input[name="description"]').val(response.description);
                        editWallWidget.find('select[name="template_name"]').val(response.template_name).change();
                        editWallWidget.find('textarea[name="description"]').val(response.description);
                        editWallWidget.find('select[name="visibility_type"]').val(response.visibility_type).change();
                        editWallWidget.find('select[name="posting_access_type"]').val(response.posting_access_type).change();

                    } else {
                        alert('Ошибка: ' + response.message);
                    }
                },
                error: function () {
                    alert('Ошибка запроса.');
                }
            });

        }
        document.getElementById('langSelect').addEventListener('change', function () {
            const value = this.value;
            $("#selectedLanguage").html(value);
            document.querySelectorAll('.tab-pane').forEach(p => {
                p.classList.remove('show', 'active');
            });
            document.getElementById(value).classList.add('show', 'active');
        });
        var wabSection = document.getElementById('wabSection');
        wabSection.classList.add('active');
        var widgetsAndBanners = document.getElementById('widgetsAndBanners');
        widgetsAndBanners.classList.add('show');

        $("#wallWidgets").addClass("active");
    });
</script>