<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */
    
    // Определяем ключ для языка в сессии в зависимости от $config['lang_union']
    $session_lang_key = $config['lang_union'] ? 'lang' : 'language';

    // Функция для загрузки языкового файла
    function load_language($lang_code) {
        // Путь к основному языковому файлу
        $lang_file = ENGINE_DIR . "/lang/{$lang_code}/admin.lng"; // Путь к языковому файлу для админки
        $fields_file = ENGINE_DIR . "/lang/{$lang_code}/fields.lng"; // Путь к языковому файлу для полей
    
        // Загружаем основной языковой файл
        if (file_exists($lang_file)) {
            $lang = include $lang_file; // Возвращаем массив
        } else {
            // Если язык не найден, используем язык по умолчанию (например, русский)
            $lang = include ENGINE_DIR . "/lang/ru/admin.lng"; // Путь к русскому файлу
        }
    
        // Загружаем файл для полей, если он существует
        if (file_exists($fields_file)) {
            $fields = include $fields_file; // Возвращаем массив полей
            // Объединяем массивы
            $lang = array_merge($lang, $fields);
        } else {
            // Если файл для полей не найден, используем данные по умолчанию
            $fields_default = include ENGINE_DIR . "/lang/ru/fields.lng";
            $lang = array_merge($lang, $fields_default);
        }
        return $lang;
    }

    // Функция для получения доступных языков
    function get_available_languages() {
        $lang_dir = ENGINE_DIR . '/lang';
        $languages = [];
        if (is_dir($lang_dir)) {
            $folders = scandir($lang_dir);
            foreach ($folders as $folder) {
                if ($folder !== '.' && $folder !== '..' && is_dir($lang_dir . '/' . $folder)) {
                    $languages[] = $folder;
                }
            }
        }
        return $languages;
    }

    // Сначала проверяем, был ли язык передан через URL
    if (isset($_GET['lang'])) {
        $lang = $_GET['lang'];
        // Проверяем, существует ли папка с языковым файлом
        if (is_dir(ENGINE_DIR . "/lang/{$lang}")) {
            $_SESSION[$session_lang_key] = $lang; // Сохраняем выбранный язык в сессии
        }
        // После установки языка через URL, перенаправляем на тот же URL без параметра lang
        $current_url = strtok($_SERVER['REQUEST_URI'], '?'); // Убираем параметры из URL
        header("Location: $current_url");
        exit;
    }

    // Обрабатываем смену языка через форму
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['form_type']) && $_POST['form_type'] === 'language_switch') {
            $lang = $_POST['lang'];
            // Проверяем, существует ли папка с языковым файлом
            if (is_dir(ENGINE_DIR . "/lang/{$lang}")) {
                $_SESSION[$session_lang_key] = $lang; // Сохраняем выбранный язык в сессии
            }
            // Получаем текущий URL из скрытого поля
            $current_url = $_POST['current_url'] ?? $_SERVER['PHP_SELF']; // Используем POST или PHP_SELF как fallback
            // Перенаправляем пользователя обратно на страницу
            header("Location: $current_url");
            exit;
        }
    }

    // Устанавливаем язык из сессии или используем язык по умолчанию
    $lang_code = isset($_SESSION[$session_lang_key]) ? $_SESSION[$session_lang_key] : $config['default_lang'];

    // Загружаем языковой файл
    $lang = load_language($lang_code);

    // Получаем доступные языки
    $available_languages = get_available_languages();

    // Передаем данные в шаблон
    $smarty->assign('lang', $lang);
    $smarty->assign('available_languages', $available_languages);
    $smarty->assign('current_lang', $lang_code);

    // Получаем текущий URL
    $current_url = $_SERVER['REQUEST_URI'];
    $smarty->assign('current_url', $current_url);