<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Функция для генерации блока с пагинацией
    function generatePagination($currentPage, $totalPages) {
        $pagination = [];
        // Определение количества отображаемых кнопок на пагинации
        $numVisibleButtons = 5;
        // Определение начальной и конечной страниц для отображения
        $start = max($currentPage - floor($numVisibleButtons / 2), 1);
        $end = min($start + $numVisibleButtons - 1, $totalPages);
        // Коррекция начальной страницы, чтобы не выйти за границы
        $start = max(1, $end - $numVisibleButtons + 1);
        // Генерация видимых кнопок
        for ($i = $start; $i <= $end; $i++) {
            $pagination[] = ['label' => $i, 'number' => $i, 'class' => ($i == $currentPage) ? 'active' : ''];
        }
        return $pagination;
    }