<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require 'vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Создаем экземпляр PHPMailer

function sendEmail($toEmail, $html, $subject)
{
    global $config;

    try {
        $mail = new PHPMailer(true);

        // Настройки сервера
        $mail->isSMTP();                                            // Использовать SMTP
        $mail->Host       = $config["email_settings"]["host"];                     // Укажите ваш SMTP сервер
        $mail->SMTPAuth   = $config["email_settings"]["smtp_auth"];                                   // Включить аутентификацию SMTP
        $mail->Username   = $config["email_settings"]["username"];                     // SMTP username
        $mail->Password   = $config["email_settings"]["password"];                               // SMTP password
        $mail->SMTPSecure = $config["email_settings"]["smtp_secure"];         // Включить шифрование TLS
        $mail->Port       = $config["email_settings"]["port"];                                    // TCP port для подключения

        // Отправитель и получатель
        $mail->setFrom('megadigital@docsign.space', 'Mega Digital Studio');
        $mail->addAddress($toEmail, $toEmail);            // Добавить получателя
        //  $mail->addReplyTo('info@example.com', 'Information');       // Укажите адрес для ответа

        // Вложения
        // $mail->addAttachment('/var/tmp/file.tar.gz');            // Добавить вложение
        // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');       // Опционально: изменить имя файла

        // Содержимое письма
        $mail->isHTML(true);                                        // Установить формат письма в HTML
        $mail->Subject = $subject;
        $mail->Body    = $html;
        $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

        $mail->send();
        return true;
    } catch (Exception $e) {
        return "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
    }
}
