<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Ассоциативный массив зарезервированных URL и сообщений об ошибках, включая запрещённые символы
    $reserved_urls = [
        '' => "URL не может быть пустым.",
        'ads' => "URL 'ads' зарезервирован для страницы объявлений.",
        'ac' => "URL 'ac' зарезервирован для страницы категорий объявлений.",
        'files' => "URL 'files' зарезервирован для страницы файлов.",
        'fc' => "URL 'fc' зарезервирован для страницы категорий файлов.",
        'movies' => "URL 'movies' зарезервирован для страницы фильмов.",
        'mc' => "URL 'mc' зарезервирован для страницы категорий фильмов.",
        'news' => "URL 'news' зарезервирован для страницы новостей.",
        'nc' => "URL 'nc' зарезервирован для страницы категорий новостей.",
        'products' => "URL 'products' зарезервирован для страницы товаров.",
        'pc' => "URL 'pc' зарезервирован для страницы категорий товаров.",
        'shc' => "URL 'shc' зарезервирован для страницы категорий товаров онлайн магазинов.",

        // Запрещённые символы
        'forbidden_chars' => ['/', '\\', '?', '%', '*', ':', '|', '"', '<', '>', '#', '&', '!', '^', '@', '$', '(', ')', '[', ']', '{', '}', '+', '=', ';', '~', '`', ',', '.', '\'', '№']
    ];

    // Функция для проверки наличия запрещённых символов в строке
    function containsForbiddenChars($url, $forbidden_chars) {
        foreach ($forbidden_chars as $char) {
            if (strpos($url, $char) !== false) {
                return $char; // Возвращаем символ, если он найден
            }
        }
        return false; // Возвращаем false, если запрещённых символов нет
    }