<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

function renderTempTpl($smarty, $content) {
    // Создаем временный файл в директории системы
    $tempFile = tempnam(sys_get_temp_dir(), 'tpl_') . '.tpl';

    // Извлекаем все include
    preg_match_all('/\{include file="([^"]+)"(.*?)\}/', $content, $matches, PREG_SET_ORDER);

    $includes = [];
    foreach ($matches as $match) {
        $includes[] = trim($match[0]);
    }

    // Записываем переданный контент в файл
    file_put_contents($tempFile, $content);

    // Рендерим шаблон через Smarty
    $html = $smarty->fetch($tempFile);

    // Удаляем временный файл
    unlink($tempFile);

    // Возвращаем сгенерированный HTML и список include
    return [
        'html' => $html,
        'includes' => implode(', ', $includes)
    ];
}
