<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Передаем текущий URL в шаблон
    $current_url = $_SERVER['REQUEST_URI'];
    $smarty->assign('current_url', $current_url);

    // Проверка, какая форма была отправлена
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // 1. Запрос на добавление задачи,
        if (isset($_POST['action']) && $_POST['action'] === 'add_task') {
            $title = $_POST['title'] ?? '';
            $author = 'AuthorName'; // Можно заменить на имя текущего пользователя
            $description = $_POST['description'] ?? '';
            $status = 'pending'; // Устанавливаем статус по умолчанию
            $date = date('Y-m-d');
         /*   $query = "INSERT INTO `tasks` (`title`, `author`, `date`, `description`, `status`, `views`) VALUES ('$title', '$author', '$date', '$description', '$status', 0)";

            $result = $db_connect->query($query);*/

            $result = $db_connect->insert("tasks", [
                "title" => $title,
                "author" => $author,
                "description" => $description,
                "status" => $status,
                "date" => $date,
                "views" => 0
            ]);

            if ($result) {
                // Перенаправляем на ту же страницу после успешного добавления
                $redirect_url = $_POST['add_current_url'];
                header("Location: " . $redirect_url);
                exit(); // Завершаем выполнение скрипта после редиректа
            } else {
                echo 'Ошибка: ' . mysqli_error($db_connect);
            }
        }

        // 2. Запрос на изменение статуса задачи
        if (isset($_POST['action']) && $_POST['action'] === 'update_status') {
            $task_id = $_POST['task_id'] ?? 0;
            $new_status = $_POST['status'] ?? '';

            if ($task_id > 0 && in_array($new_status, ['pending', 'inprogress'])) {
                $result = $db_connect->update("tasks", [
                    "status" => $new_status
                ], ["id" => $task_id]);

                if ($result) {
                    $redirect_url = $_POST['update_current_url'];
                    header("Location: " . $redirect_url);
                    exit();
                } else {
                    echo 'Ошибка: ' . mysqli_error($db_connect);
                }
            } else {
                echo 'Некорректный ID задачи или статус.';
            }
        }

        // 3. Запрос на удаление задачи
        if (isset($_POST['action']) && $_POST['action'] === 'delete_task') {
            $task_id = $_POST['task_id'] ?? 0;
            $result = $db_connect->delete("tasks", ["id" => $task_id]);

            if ($result) {
                $redirect_url = $_POST['delete_current_url'];
                header("Location: " . $redirect_url);
                exit();
            } else {
                echo 'Ошибка: ' . mysqli_error($db_connect);
            }
        }
    }

    // 4. Запрос на отображение задач
    $tasks = $db_connect->select("tasks", "*", [
        "ORDER" => ["date" => "DESC"]
    ]);

    // Преобразование статуса для каждой задачи
    foreach ($tasks as &$task) {
        $task['status'] = isset($task['status']) ? $task['status'] : 'pending';
    }

    // Передаем данные в шаблон
    $smarty->assign('tasks', $tasks);
    $smarty->assign('stheme', $config['stheme']);
    $smarty->assign('tasks_list', $smarty->fetch(SYSTEM_DIR . '/tpl/tasks/tasks.tpl'));
    $smarty->assign('task_add_form', $smarty->fetch(SYSTEM_DIR . '/tpl/tasks/add_task.tpl'));