<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Подключение конфигурационного файла
    require_once(ENGINE_DIR . '/data/config.php');

    // Проверяем соединение
   /* if ($db_connect->connect_error) {
        die("Ошибка подключения: " . $db_connect->connect_error);
    }
	*/
    // Сбрасываем счетчик автоинкремента к максимальному значению id
    require_once(ENGINE_DIR . '/mods/autoincrement.php');
   // list($page_id, $max_id) = resetAutoIncrement($db_connect, 'static_pages');
        
    // Подключаем файл проверки зарезервированных URL и запрещённых символов
    require_once(SYSTEM_DIR . '/plugins/reserved_urls.php');

    // Обработка формы добавления страницы
    if (isset($_POST['addpage'])) {
        // Получаем данные из формы
        $date = isset($_POST['date']) && !empty($_POST['date']) ? strip_tags(trim($_POST['date'])) : date($config['date_format']);
        $title = strip_tags(trim($_POST['title']));
        $language = isset($_POST['language']) ? (is_array($_POST['language']) ? implode(', ', $_POST['language']) : $_POST['language']) : '';
        $alt_name = strip_tags(trim($_POST['alt_name']));
        $full_desc = htmlspecialchars($_POST['full_desc'], ENT_QUOTES);
        $meta_desc = strip_tags(trim($_POST['meta_desc']));
        $meta_keys = strip_tags(trim($_POST['meta_keys']));
        $views = isset($_POST['views']) ? intval($_POST['views']) : 0;
        $full_meta_desc = htmlspecialchars($_POST['full_desc'], ENT_QUOTES);;

        // Проверяем, содержит ли URL запрещённые символы
        $forbidden_char_found = containsForbiddenChars($alt_name, $reserved_urls['forbidden_chars']); // Проверяем без преобразования в нижний регистр
        
        if ($forbidden_char_found) {
            // Если найден запрещённый символ, создаём сообщение об ошибке
            $error_message = "Ошибка: URL содержит запрещённый символ: '{$forbidden_char_found}'.";
            $smarty->assign('error_message', $error_message);
        }
        // Преобразуем URL в нижний регистр для проверки на зарезервированные значения
        elseif (array_key_exists(strtolower($alt_name), $reserved_urls)) {
            // Если URL зарезервирован, создаём сообщение об ошибке
            $error_message = "Ошибка: " . $reserved_urls[strtolower($alt_name)];
            $smarty->assign('error_message', $error_message);
        } else {
            // Выполняем запрос на добавление страницы в базу данных

            $lastId = $db_connect->max("static_pages", "id");

            if ($_POST["show_select_widget"] === "on") {
                if (str_contains($full_desc, "{payment-widget}") || str_contains($full_desc, "{ payment-widget }")) {

                    $widget = $db_connect->get("payment_widgets", "*", ["id" => $_POST["selected_widget"]]);

                    if (!empty($widget)) {
                        $db_connect->insert("widget_objects", [
                            "object_name" => $alt_name,
                            "object_id" => $lastId + 1,
                            "widget_name" => $widget["template_name"],
                            "widget_id" => $widget["id"],
                            "active" => 1
                        ]);

                       /* $smarty->assign("currency", getCurrentCurrency());

                        $moduleName = $alt_name;
                        $moduletype["id"] = $lastId + 1;
                        require_once(ENGINE_DIR . '/mods/widget-select.php');
                        $smarty->assign('dynamicName', "pages");
                        $smarty->assign('price', $widget["price"]);
                        $smarty->assign('widgetId', $widget["id"]);

                        $html = $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/payments-widgets/' . $widget["template_name"] . ".tpl");
                        $full_desc = preg_replace('/\{\s*payment-widget\s*\}/', $html, $full_desc);*/
                    }
                }

            } else {
                $full_desc = preg_replace('/\{\s*payment-widget\s*\}/', "", $full_desc);
            }


            $inserted = $db_connect->insert("static_pages", [
                "id" => $lastId + 1,
                "date" => $date,
                "alt_name" => $alt_name,
                "language" => $language,
                "title" => $title,
                "full_desc" => $full_desc,
                "meta_desc" => $meta_desc,
                "meta_keys" => $meta_keys,
                "views" => $views,
                "full_meta_desc" => $full_meta_desc,
            ]);

            require_once ENGINE_DIR . '/mods/access_control.php';
            saveAccessSettings((int)$lastId + 1, "pages", $_POST["exclude_locations"] ?? [], $_POST["include_locations"] ?? [], $_POST["groups"]);

            // Проверяем результат выполнения запроса
            if ($inserted) {
                // Перенаправление на ту же страницу после добавления
                header("Location: /admin?action=pages");
                exit();
            } else {
                $error_message .= "Ошибка при добавлении файла: " . $db_connect->error . "<br>";
            }
        }
    }

    $widgets = $db_connect->select("payment_widgets", "*");

    $groups = $db_connect->select("roles", "*") ?? [];
    $smarty->assign('groups', $groups);

// Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['nav']['addpages'] . ' - ' . $config['title']);
    $smarty->assign("POST", $_POST);
    $_POST = [];
    $smarty->assign('data', $yourData);
    $smarty->assign('p_widgets', $widgets);
    $smarty->assign('page_name', '
            <li class="breadcrumb-item active"><a href="/admin?action=pages">Страницы</a></li>
            <li class="breadcrumb-item active">' . $lang['nav']['addpages'] . '</li>
        ');
    $smarty->assign('add_page', 'add_page');
	$smarty->assign('page_id', 0);
    $smarty->assign('max_id', 0 + 1);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);