<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    global $db_connect, $config, $lang;

    if (!isset($_SESSION['bw_form_key'])) {
        $_SESSION['bw_form_key'] = uniqid();
    }

    if (!empty($_POST["form_key"]) && $_POST['form_key'] == $_SESSION['bw_form_key']) {

        if (isset($_POST["create_banned_word"])) {

            $db_connect->insert("banned_words", [
               "word" => $_POST["word"],
               "created_at" => date("Y-m-d H:i:s"),
            ]);
        } else if (isset($_POST["edit_banned_word"]) && !empty($_POST["bw_id"])) {
            $db_connect->update("banned_words", [
                "word" => $_POST["word"],
            ], [
                "id" => $_POST["bw_id"],
            ]);
        } else if (!empty($_POST["delete_bw_id"])) {
            $db_connect->delete("banned_words", [
                "id" => (int)$_POST["delete_bw_id"],
            ]);
        }
        header("Location: ".$_SERVER["HTTP_REFERER"]);

    }

    $bannedWords = $db_connect->select("banned_words", "*", [
        "ORDER" => ["id" => "DESC"],
    ]);

    foreach ($bannedWords as $key => &$bannedWord) {

        $bannedWord[$lang['datatable']['uniq_id']] = $key+1;

        $bannedWord[$lang['datatable']['word']] = $bannedWord['word'];
        $bannedWord[$lang['datatable']['created_at']] = $bannedWord['created_at'];
        $bannedWord[$lang['datatable']['actions']] = "<a href='#' class='mx-1 top-1 edit-banned-word' data-id='{$bannedWord["id"]}' data-word='{$bannedWord["word"]}' data-id=''><i class='fa fa-edit'></i></a>
                            <form method='POST' action='/admin?action=banned-words' style='display:inline;'>
                                <input type='hidden' name='delete_bw_id' value='{$bannedWord['id']}'>
                                <input type='hidden' name='form_key' value='{$_SESSION['bw_form_key']}'>
                                <button type='submit' class='no-b mx-1' onclick='return confirm(`Вы уверены, что хотите удалить?`);'>
                                    <i class='fa fa-trash'></i>
                                </button>
                            </form>";

    }


    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });
    $yourData = array('title' => $lang['nav']['bannedwords'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('bannedWords', $bannedWords);
    $smarty->assign('form_key', $_SESSION['bw_form_key']);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['nav']['bannedwords'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);