<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');


    // --- Получаем текущий URL ---
    $currentUrl = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    $currentUrl = rtrim($currentUrl, '/'); // убрать конечный слеш

    // --- Обработка POST-запроса (добавление привязки) ---
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['parent_url']) && !empty($_POST['module_url']) && empty($_POST['edit_id']) ) {
        $parentUrl = rtrim(trim($_POST['parent_url']), '/');
        $moduleUrl = rtrim(trim($_POST['module_url']), '/');

        // Проверка на дубликаты
        if (!$db_connect->has('bindings', ['parent_url' => $parentUrl, 'module_url' => $moduleUrl])) {
            $db_connect->insert('bindings', [
                'binding_name' => $_POST["binding_name"],
                'parent_url'  => $parentUrl,
                'module_url'  => $moduleUrl ?? "",
                'parent_name' => $_POST['parent_name'] ?? basename($parentUrl),
                'module_name' => $_POST['module_name'] ?? basename($moduleUrl),
                'created_at'  => date('Y-m-d H:i:s'),
                'translate_child' => $_POST['translate_child'],
                'translate_parent' => $_POST['translate_parent'],
            ]);
        } else {
            $smarty->assign("error_title", "Дубликаты запрешены");
            $smarty->assign('error_message', "Привязка с такимы значениями уже существует");
            $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/error.tpl');
        }

        header('Location: '.$_SERVER['REQUEST_URI']);
        exit;
    }

    // --- Обработка POST-запроса (редактирование привязки) ---
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['edit_id'])) {
        $editId = (int)$_POST['edit_id'];
        $parentUrl = rtrim(trim($_POST['parent_url']), '/');
        $moduleUrl = rtrim(trim($_POST['module_url']), '/');

        $db_connect->update('bindings', [
            'binding_name' => $_POST["binding_name"],
            'parent_url' => $parentUrl,
            'module_url' => $moduleUrl,
            'parent_name' => $_POST['parent_name'] ?? basename($parentUrl),
            'module_name' => $_POST['module_name'] ?? basename($moduleUrl),
            'translate_child' => $_POST['translate_child'],
            'translate_parent' => $_POST['translate_parent'],
        ], ['id' => $editId]);

        header('Location: '.$_SERVER['REQUEST_URI']);
        exit;
    }


    // --- Удаление привязки ---
    if (!empty($_POST['delete_binding_id'])) {
        $id = (int)$_POST['delete_binding_id'];
        $db_connect->delete('bindings', ['id' => $id]);
        header('Location: '.$_SERVER['REQUEST_URI']);
        exit;
    }

    // --- Получаем все привязки ---
    $bindings = $db_connect->select('bindings', '*');

    foreach ($bindings as &$binding) {

        $binding["actions"] = "
            <button type='button'
                class='btn'
                data-bs-toggle='modal'
                data-bs-target='#editBindingModal'
    
                data-id='{$binding["id"]}'
                data-name='{$binding["binding_name"]}'
                data-parent-url='{$binding["parent_url"]}'
                data-module-url='{$binding["module_url"]}'
                data-tr-parent='{$binding["translate_parent"]}'
                data-tr-child='{$binding["translate_child"]}'
            >
                <i class='fa fa-edit'></i>
            </button> <form method='POST' action='/admin?action=bindings-control' style='display:inline;'>
                                    <input type='hidden' name='delete_binding_id' value='{$binding['id']}'>
                                    <button type='submit' class='no-b mx-1' onclick='return confirm(`Вы уверены, что хотите удалить эту привязку?`);'>
                                        <i class='fa fa-trash'></i>
                                    </button>
                                </form>
        ";
    }

    unset($binding);

    // --- Получаем все родители и модули для формы ---
    $parents = $db_connect->select('bindings', ['parent_url', 'parent_name'], ['GROUP' => 'parent_url']);
   // $modules = $db_connect->select('bindings', ['module_url', 'module_name'], ['GROUP' => 'module_url']);
    $modules = ['ads', 'events', 'files', 'movies', 'news', 'products', 'shops'];

    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">Упраление привязками</li>
    ');
    $yourData = array('title' => 'Упраление привязками - ' . $config['title']);
    $smarty->assign('data', $yourData);

    // --- Текущий модуль ---
    $moduleName = $db_connect->get('bindings', 'module_name', ['module_url' => $currentUrl]) ?: 'Новый модуль';
    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });
    // --- Данные для TPL ---
    $smarty->assign([
        'bindings'    => $bindings,
        'parents'     => $parents,
        'modules'     => $modules,
        'moduleName'  => $moduleName,
        'title'       => $moduleName . ' - Управление привязками',
    ]);
