<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    global $smarty, $db_connect, $lang, $config;

    $versions = $db_connect->select("versions", "*", [
        "ORDER" => ["id" => "DESC"],
     //   "LIMIT" => 5
    ]);

    $activeVersion = $db_connect->get("versions", "*", ["is_active" => 1]);

    foreach ($versions as $key => &$version) {

        $isActiveVersion = false;
        $disabled = "";
        if ($version["is_active"] == 1) {
            $isActiveVersion = true;
            $btnName = $lang["tools"]["active"];
            $disabled = "disabled";
        } else {
            $btnName = $lang["datatable"]["activate"];
        }

        $version[$lang["datatable"]["uniq_id"]] = $key+1;
        $version[$lang["datatable"]["system_version"]] = "v. ".$version["system_version"];
        $version[$lang["datatable"]["release_date"]] = $version["release_date"];
        $version[$lang["datatable"]["actions"]] = "<a class='btn' href='{$version["file_path"]}' ><svg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='currentColor' class='bi bi-download' viewBox='0 0 16 16'>
        <path d='M.5 9.9a.5.5 0 0 1 .5.5v2.5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2.5a.5.5 0 0 1 1 0v2.5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-2.5a.5.5 0 0 1 .5-.5'/>
        <path d='M7.646 11.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V1.5a.5.5 0 0 0-1 0v8.793L5.354 8.146a.5.5 0 1 0-.708.708z'/>
        </svg></a> <a class='btn btn-success activateVersion $disabled' data-id='{$version["id"]}' href='#' >$btnName</a>";

    }
    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });
    $smarty->assign('activeVersion', $activeVersion);
    $smarty->assign('versions', $versions);
    $yourData = array('title' => $lang['nav']['versioncontrol'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['nav']['versioncontrol'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);