<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Удаление комментария
        if (isset($_POST['delete_comment_id'])) {
            $comment_id = intval($_POST['delete_comment_id']);
            $db_connect->delete("comments", ["id" => $comment_id]);
    
            header("Location: " . $_SERVER['REQUEST_URI']);
            exit();
        }
    
        // Обновление комментария
        if (isset($_POST['comment_id'])) {
            $comment_id = intval($_POST['comment_id']);
            $author = $_POST['author'] ?? '';
            $comment_text = $_POST['comment_text'] ?? '';
            $status = isset($_POST['status']) ? intval($_POST['status']) : 0;
    
            if ($comment_id > 0 && !empty($comment_text)) {
                $stmt = $db_connect->update("comments", [
                    "author" => $author,
                    "comment_text" => $comment_text,
                    "status" => $status
                ], ["id" => $comment_id]);

                if ($stmt) {
                    header("Location: " . $_SERVER['REQUEST_URI']);
                    exit();
                } else {
                    echo 'Ошибка: ' . $stmt->error;
                }
                $stmt->close();
            } else {
                echo 'Некорректные данные комментария.';
            }
        }
    }

    $comments = $db_connect->select("comments", "*", [
        'ORDER' => ['created_at' => 'DESC'],
    ]);

    $smarty->assign('comments', $comments);

    $yourData = array('title' => $lang['nav']['commentscontrol'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['nav']['commentscontrol'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);