<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    $tasks = [];
    $lines = file(ENGINE_DIR.'/data/cron-jobs.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $index => $line) {
        $parts = preg_split('/\s+/', $line, 6);
        if (count($parts) == 6) {
            $tasks[] = [
                'id' => $index, // нужен для удаления/редактирования
                'expr' => implode(' ', array_slice($parts, 0, 5)),
                'command' => $parts[5]
            ];
        }
    }

    $taskDir = ENGINE_DIR . '/jobs/';
    $files = [];

    if (is_dir($taskDir)) {
        foreach (glob($taskDir . '*.php') as $file) {
            $files[] = basename($file);
        }
    }

    $smarty->assign('taskFiles', $files);
    $yourData = array('title' => $lang['nav']['cronjobs'] . ' - ' . $config['title']);
    $smarty->assign("tasks", $tasks);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['nav']['cronjobs'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);