<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    global $db_connect, $lang, $smarty;

    $classes = $db_connect->select("classes", "*");

    $teacherRoleId = $db_connect->get("roles", "id", [
        "name[~]" => "Teacher"
    ]);

    $studentRoleId = $db_connect->get("roles", "id", [
        "name[~]" => "Student"
    ]);

    $teachersIds = $db_connect->select("users_roles", "user_id", [
        "role_id" => $teacherRoleId
    ]);

    $studentsIds = $db_connect->select("users_roles", "user_id", [
        "role_id" => $studentRoleId
    ]);

    $teachersDataAssoc = [];
    if (!empty($teachersIds)) {
        $teachersDataAssoc = $db_connect->select("users", ["id", "name"], [
            "id" => $teachersIds
        ]);
    }

    $studentsDataAssoc = [];
    if (!empty($studentsIds)) {
        $studentsDataAssoc = $db_connect->select("users", ["id", "name"], [
            "id" => $studentsIds
        ]);
    }


    foreach ($classes as $key => &$class) {

        $classTeachers = $db_connect->select("teacher_classes", "teacher_id", [
            "class_id" => $class['id']
        ]);

        $classTeachersDataAssoc = [];
        if (!empty($classTeachers)) {
            $classTeachersDataAssoc = $db_connect->select("users", "name", [
                "id" => $classTeachers
            ]);
        }

        if (!empty($classTeachersDataAssoc)) {
            $class["teachers"] = implode(", ", $classTeachersDataAssoc);
        } else {
            $class["teachers"] = $lang['education']['no_teachers'];
        }

        /* Datatable mapping */
        $class[$lang["datatable"]["name"]]    = $class["name"];
        $class[$lang["datatable"]["date"]]    = $class["created_at"];
        $class[$lang["datatable"]["actions"]] = "
            <a href='#' class='mx-3 fa fa-eye view-students-ico' data-id='{$class['id']}'>
                {$lang['education']['view_all_students']}
            </a>
            <a href='#' class='mx-3 fa fa-edit edit-ico' data-id='{$class['id']}'></a>
            <a href='#' class='mx-3 fa fa-trash delete-ico' data-id='{$class['id']}'></a>
        ";
    }
    unset($class);

    /* Smarty */
    $smarty->registerPlugin('modifier', 'json_encode', function ($value) {
        return json_encode($value);
    });

    $yourData = array(
        'title' => $lang['education']['classes'] . ' - ' . $config['title']
    );

    $smarty->assign('classes', $classes);
    $smarty->assign('teachers', $teachersDataAssoc);
    $smarty->assign('students', $studentsDataAssoc);
    $smarty->assign('data', $yourData);

    $smarty->assign(
        'page_name',
        '<li class="breadcrumb-item active">' . $lang['education']['classes'] . '</li>'
    );

    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);