<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    global $db_connect, $lang, $smarty;

    // ID ролей
    $parentRoleId = $db_connect->get("roles", "id", ["name" => "Parent"]);
    $studentRoleId = $db_connect->get("roles", "id", ["name" => "Student"]);

    // Родители (имена)
    $parentNames = $db_connect->select("users", [
        "[>]users_roles" => ["id" => "user_id"]
    ], "users.name", [
        "users_roles.role_id" => $parentRoleId,
        "users.banned" => 0
    ]);

    $parentsDataList = $db_connect->select("users", [
        "[>]users_roles" => ["id" => "user_id"]
    ], ["name", "email", "id"], [
        "users_roles.role_id" => $parentRoleId,
        "users.banned" => 0
    ]);

    $parentsText = !empty($parentNames)
        ? implode(", ", $parentNames)
        : "Родителей нет";

    // Ученики
    $students = $db_connect->select("users", [
        "[>]users_roles" => ["id" => "user_id"]
    ], [
        "users.id",
        "users.name",
        "users.regdate"
    ], [
        "users_roles.role_id" => $studentRoleId,
        "users.banned" => 0
    ]);

    $smarty->assign("studentsDataList", $students);

    // Подготовка под datatable
    foreach ($students as &$student) {

        $parentIds = $db_connect->select("parents_students", "parent_id", ["student_id" => $student["id"]]);
        $thisParentsName = [];
        if (!empty($parentIds)) {
            $thisParentsName = $db_connect->select("users", "name", [
                "id" => $parentIds
            ]);
        }


        $student["parents"] = !empty($thisParentsName)
            ? implode(", ", $thisParentsName)
            : "Родителей нет";

        $student[$lang["datatable"]["name"]] = $student["name"];
        $student[$lang["datatable"]["date"]] = $student["regdate"];
        $student[$lang["datatable"]["actions"]] = "
            <a href='#' class='mx-3 fa fa-edit edit-ico' data-id='{$student['id']}'></a>
            <a href='#' class='mx-3 fa fa-trash delete-ico' data-id='{$student['id']}'></a>
        ";
    }
    unset($student);


    $smarty->assign('students', $students);

    /** Системные данные */
    $yourData = [
        'title' => "Ученики / Родители" . ' - ' . $config['title']
    ];
    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });
    $smarty->assign('parentsDataList', $parentsDataList);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . "Ученики / Родители" . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);