<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    global $db_connect, $lang, $smarty;

    $subjects = $db_connect->select("subjects", "*");

    $teacherRoleId = $db_connect->get("roles", "id", [
        "name[~]" => "Teacher"
    ]);

    $teachersIds = $db_connect->select("users_roles", "user_id", [
        "role_id" => $teacherRoleId
    ]);


    $teachersDataAssoc = [];
    if (!empty($teachersIds)) {
        $teachersDataAssoc = $db_connect->select("users", ["id", "name", "email"], [
            "id" => $teachersIds
        ]);
    }

    foreach ($subjects as &$subject) {

        $subject[$lang["datatable"]["name"]] = $subject["subject"];
        $subject[$lang["datatable"]["actions"]] = "<a href='#' id='edit-ico' class='mx-3 fa fa-edit edit-ico' data-id='{$subject['id']}'></a>
                            <a href='#' id='delete-ico' class='mx-3 fa fa-trash delete-ico' data-id='{$subject['id']}'></a>";
    }
    unset($subject);

    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });
    $smarty->assign('teachers', $teachersDataAssoc);
    $smarty->assign('subjects', $subjects);
    $yourData = array('title' => "Предметы" . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . "Предметы" . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);