<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    global $db_connect, $lang, $smarty;

    $teacherRoleId = $db_connect->get("roles", "id", [
        "name[~]" => "Teacher"
    ]);

    $teachersIds = $db_connect->select("users_roles", "user_id", [
        "role_id" => $teacherRoleId
    ]);


    $teachersDataAssoc = [];

    if (!empty($teachersIds)) {
        $teachersDataAssoc = $db_connect->select("users", ["id", "name", "email"], [
            "id" => $teachersIds
        ]);
    }


    foreach ($teachersDataAssoc as &$teacherDataAssoc) {

        $teacherClassesIds = $db_connect->select("teacher_classes", "class_id", [
            "teacher_id" => $teacherDataAssoc["id"],
        ]);

        $classes = [];
        if ($teacherClassesIds) {
            $classes = $db_connect->select("classes", "name", [
                "id" => $teacherClassesIds
            ]);
        }

        if ($classes) {
            $teacherDataAssoc["classes"] = implode(", ", $classes);
        } else {
            $teacherDataAssoc["classes"] = "Нету привязанных классов";
        }

        $teacherDataAssoc[$lang["datatable"]["name"]] = $teacherDataAssoc["name"];
        $teacherDataAssoc[$lang["datatable"]["email"]] = $teacherDataAssoc["email"];

        $teacherDataAssoc[$lang["datatable"]["actions"]] = "<a href='#' id='edit-ico' class='mx-3 fa fa-edit edit-ico' data-id='{$teacherDataAssoc['id']}'></a>
                            <a href='#' id='delete-ico' class='mx-3 fa fa-trash delete-ico' data-id='{$teacherDataAssoc['id']}'></a>";
    }
    unset($teacherDataAssoc);

    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });
    $smarty->assign('teachers', $teachersDataAssoc);
    $yourData = array('title' => "Учителя" . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . "Учителя" . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);