<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_feedback_id'])) {
        $feedback_id = intval($_POST['delete_feedback_id']);
        $stmt = $db_connect->prepare("DELETE FROM feedback_orders WHERE id = ?");
        $stmt->bind_param('i', $feedback_id);
        $stmt->execute();
        $stmt->close();
    
        // Перенаправление на текущую страницу для обновления списка заявок
        header("Location: " . $_SERVER['REQUEST_URI']);
        exit();
    }

    // SQL запрос для извлечения заявок, отсортированных по дате создания (новые вверху)
    $sql = "SELECT id, name, email, phone, subject, message, ip, city, created_at FROM feedback_orders ORDER BY created_at DESC";

    $feedback_orders = $db_connect->query($sql);


    $yourData = array('title' => $lang['nav']['feedbackrequests'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['nav']['feedbackrequests'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('feedback_orders', $feedback_orders);
    $smarty->assign('config', $config);