<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    $langDirectory = ENGINE_DIR . '/lang/';
    $subAction = isset($_GET['sub_action']) ? $_GET['sub_action'] : '';
    $currentDir = isset($_GET['dir']) ? $_GET['dir'] : '';
    $langFiles = [];

    // Функция для получения файлов и папок в директории
    function getFilesInDirectory($directory, $baseDir = '') {
        $files = [];
        $allItems = scandir($directory);
        $allItems = array_diff($allItems, array('.', '..'));

        foreach ($allItems as $item) {
            $fullPath = rtrim($directory, '/') . '/' . $item;
            if (is_dir($fullPath)) {
                // Папка
                $files[$baseDir . $item] = 'dir';
            } elseif (pathinfo($item, PATHINFO_EXTENSION) === 'lng') {
                // Файл .lng
                $files[$baseDir . $item] = 'file';
            }
        }

        return $files;
    }

    // Получить все файлы и директории
    $langFiles = getFilesInDirectory($langDirectory . $currentDir);
    $langFile = '';

    if ($subAction === 'edit') {
        $langFile = isset($_GET['lang_file']) ? $_GET['lang_file'] : '';

        if (!empty($langFile)) {
            $langFilePath = $langDirectory . $langFile;
            if (file_exists($langFilePath)) {
                $langContent = file_get_contents($langFilePath);
                $langContentEscaped = htmlspecialchars($langContent, ENT_QUOTES, 'UTF-8');
                $smarty->assign('lang_file', $langFile);
                $smarty->assign('lang_content', $langContentEscaped);
            } else {
                echo 'Файл не найден.';
                exit;
            }
        }
    } elseif ($subAction === 'save') {
        $langFile = isset($_POST['lang_file']) ? $_POST['lang_file'] : '';
        $langContent = isset($_POST['lang_content']) ? $_POST['lang_content'] : '';
        if (!empty($langFile)) {
            $langFilePath = $langDirectory . $langFile;
            // Сохраняем изменения в файл
            file_put_contents($langFilePath, htmlspecialchars_decode($langContent, ENT_QUOTES));
            echo 'Файл успешно сохранен.';
            exit;
        }
    }

    // Установить значение по умолчанию для lang_file
    if (empty($langFile)) {
        $langFile = 'Не выбрано'; // Устанавливаем "Не выбрано" если langFile пустое
    }

    // Передаем данные для отображения
    $smarty->assign('lang_files', $langFiles);
    $smarty->assign('langDirectory', $langDirectory);
    $smarty->assign('current_dir', $currentDir);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);

    // Передаем значение lang_file в шаблон
    $smarty->assign('lang_file', $langFile);
    $yourData = array('title' => $lang['megamenu']['languagesettings'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['megamenu']['languagesettings'] . '</li>
    ');