<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    $result = $db_connect->select("license_keys", "*");

    
    $licenses = array();

    foreach ($result as $row) {
        $created_date = new DateTime($row['created_date']);
        $current_date = new DateTime();

        // Проверяем тип лицензии
        if ($row['version'] === 'lifetime') {
            $row['remaining_days'] = 'неограничено';
        } elseif ($row['version'] === 'yearly') {
            $expiration_date = clone $created_date;
            $expiration_date->modify('+365 days');

            // Вычисляем разницу в днях между текущей датой и датой истечения лицензии
            $remaining_days = $expiration_date->diff($current_date)->days;

            if ($current_date > $expiration_date) {
                $row['remaining_days'] = 'истекла';
            } else {
                $row['remaining_days'] = $remaining_days;
            }
        } else {
            $row['remaining_days'] = 'неизвестно';
        }

        $licenses[] = $row;
    }

    // Устанавливаем массив переменных в Smarty
    $smarty->assign('licenses', $licenses);    
    $yourData = array('title' => $lang['megamenu']['licensemanagement'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['megamenu']['licensemanagement'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);