<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    $mailingQueues = $db_connect->select("mailing_queue", "*");

    foreach ($mailingQueues as $key => &$mailingQueue) {

        $mailingQueue[$lang['datatable']['uniq_id']] = $key+1;
        $mailingQueue["email"/*$lang['datatable']['email']*/] = $db_connect->get("users", "email", ["id" => $mailingQueue["user_id"]]);
        $mailingQueue[$lang['datatable']['phone']] = $db_connect->get("users", "phone", ["id" => $mailingQueue["user_id"]]);
        $mailingQueue[$lang['datatable']['error']] = !empty($mailingQueue["error"]) ? "<b style='font-size: 13px'>{$mailingQueue["error"]}</b>" : $lang["datatable"]["error_empty"];
        $mailingQueue[$lang['datatable']['provider_message_id']] = $mailingQueue["provider_message_id"] ?? $lang["datatable"]["empty"];
      //  $mailingQueue[$lang['datatable']['channel']] = $mailingQueue["channel"];

        $mailingQueue[$lang["datatable"]["channel"]] = $lang["datatable"][$mailingQueue["channel"]];

        if ($mailingQueue["status"] == "draft") {
                $mailingQueue[$lang["datatable"]["status"]] = '<span class="badge bg-secondary">Черновик</span>';
            } else if ($mailingQueue["status"] == "pending" || $mailingQueue["status"] == "queued") {
                $mailingQueue[$lang["datatable"]["status"]] = '<span class="badge bg-warning text-dark">В очереди</span>';
            } else if ($mailingQueue["status"] == "sending") {
                $mailingQueue[$lang["datatable"]["status"]] = '<span class="badge bg-info text-dark">Отправляется</span>';
            } else if ($mailingQueue["status"] == "sent" || $mailingQueue["status"] == "delivered") {
                $mailingQueue[$lang["datatable"]["status"]] = '<span class="badge bg-success">Отправлено</span>';
            } else if ($mailingQueue["status"] == "failed") {
                $mailingQueue[$lang["datatable"]["status"]] = '<span class="badge bg-danger">Ошибка</span>';
            } else if ($mailingQueue["status"] == "busy") {
                $mailingQueue[$lang["datatable"]["status"]] = '<span class="badge bg-danger">Пользователь занят</span>';
            }  else if ($mailingQueue["status"] == "completed") {
                $mailingQueue[$lang["datatable"]["status"]] = '<span class="badge bg-success">Успешно завершен</span>';
            } else if ($mailingQueue["status"] == "undelivered") {
            $mailingQueue[$lang["datatable"]["status"]] = '<span class="badge bg-danger">Не доставлен</span>';
        }  else {
                $mailingQueue[$lang["datatable"]["status"]] = $mailingQueue["status"];
            }

    }
    unset($mailingQueue);

    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });
    $smarty->assign('mailingQueues', $mailingQueues);
    $yourData = array('title' => 'Очереди рассылок'. ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . 'Очереди рассылок' . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);