<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Передаем текущий URL в шаблон
    $current_url = $_SERVER['REQUEST_URI'];
    $smarty->assign('current_url', $current_url);

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

   // $groups = $db_connect->select("groups", ["id", "name"]);
    $groups = $db_connect->select("roles", "id, name");
    // Инициализируем массив для хранения данных о группах и количестве пользователей
    $groupsWithUserCount = [];

    foreach ($groups as $group) {
        // Для каждой группы получаем количество пользователей
        $userCount = $db_connect->count("users", ["group" => $group["id"]]);

        // Добавляем информацию о группе и количестве пользователей в массив
        $groupsWithUserCount[] = [
            "id" => $group["id"],
            "name" => $group["name"],
            "user_count" => $userCount
        ];
    }


// Проверка наличия данных
    if ($adsAvailable && $adsUsed) {
        $adsCount = $db_connect->count("ads");
        $smarty->assign('adsCount', $adsCount);
    }

    if ($filesAvailable && $filesUsed) {
        $filesCount = $db_connect->count("files");
        $smarty->assign('filesCount', $filesCount);
    }

    if ($moviesAvailable && $moviesUsed) {
        $moviesCount = $db_connect->count("movies");
        $smarty->assign('moviesCount', $moviesCount);
    }

    if ($newsAvailable && $newsUsed) {
        $newsCount = $db_connect->count("news");
        $smarty->assign('newsCount', $newsCount);
    }

    if ($productsAvailable && $productsUsed) {
        $productsCount = $db_connect->count("products");
        $smarty->assign('productsCount', $productsCount);
    }

    if ($eventsAvailable && $eventsUsed) {
        $eventsCount = $db_connect->count("events");
        $smarty->assign('eventsCount', $eventsCount);
    }

    // Получаем количество продаж
    $salesCount = $db_connect->count("sales");

    // Получаем количество страниц
    $pagesCount = $db_connect->count("static_pages");

    // Получаем количество пользователей
    $usersCount = $db_connect->count("users");

    // Статистика по полу
    $query = "SELECT gender, COUNT(*) AS gender_count FROM users GROUP BY gender";
    $gender_stats = $db_connect->query($query)->fetchAll();


// Инициализация переменных для каждого пола
    $maleCount = 0;
    $femaleCount = 0;
    $unknownCount = 0;

    foreach ($gender_stats as $row) {
        switch ($row['gender']) {
            case 'Мужчина':
                $maleCount = $row['gender_count'];
                break;
            case 'Женщина':
                $femaleCount = $row['gender_count'];
                break;
            case '':
                $unknownCount = $row['gender_count'];
                break;
        }
    }

    // Запрос для получения данных по возрасту
    $age_query = "SELECT age, COUNT(*) AS age_count FROM users WHERE age IS NOT NULL GROUP BY age";
    $ageData = $db_connect->query($age_query)->fetchAll();
    $formattedAgeData = array();
    foreach ($ageData as $row) {
        $formattedAgeData[] = array(
            'age' => $row['age'],
            'count' => $row['age_count']
        );
    }
    $ageData = $formattedAgeData;
    // Запрос для получения данных о пользователях по городам
    $city_query = "SELECT city, COUNT(*) AS city_count FROM users WHERE city IS NOT NULL GROUP BY city";
    $cityData = $db_connect->query($city_query)->fetchAll();

    $formattedCityData = array();
    foreach ($cityData as $row) {
        $formattedCityData[] = array(
            'city' => $row['city'],
            'count' => $row['city_count']
        );
    }
    $cityData = $formattedCityData;

    // Запрос для получения статистики по полу
    $gender_query = "SELECT gender, COUNT(*) AS gender_count FROM users GROUP BY gender";
    $genderData = $db_connect->query($gender_query)->fetchAll();

    // Подготовка данных для передачи в шаблон
    $yourData = array(
        'title' => $lang['nav']['generalinformation'] . ' - ' . $config['title'],
        'maleCount' => $maleCount,
        'femaleCount' => $femaleCount,
        'unknownCount' => $unknownCount,
        'ageData' => $ageData,
        'cityData' => $cityData,
    );
    
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item">' . $lang['nav']['generalinformation'] . '</li>
    ');
    $smarty->assign('salesCount', $salesCount);
    $smarty->assign('pagesCount', $pagesCount);
    $smarty->assign('usersCount', $usersCount);
    $smarty->assign('se_version', $config['mds_version']);

    // Проверяем тип лицензии
    if ($config['version_type'] === 'yearly') {
        // Парсим дату создания лицензии
        $createdDate = DateTime::createFromFormat('m-d-Y', $config['created_date']);
        // Создаем объект даты окончания (через один год от даты создания)
        $expirationDate = clone $createdDate;
        $expirationDate->modify('+1 year');
        // Получаем текущую дату
        $currentDate = new DateTime();
        // Вычисляем разницу между датами
        $interval = $currentDate->diff($expirationDate);
        // Оставшиеся дни
        $remainingDays = $interval->days;
        // Если текущая дата позже даты окончания, количество дней будет отрицательным
        if ($currentDate > $expirationDate) {
            $remainingDays = -$remainingDays;
        }
        // Присваиваем переменную для шаблона Smarty
        $smarty->assign('remaining_days', $remainingDays);
    } elseif($config['version_type'] === 'lifetime'){
        $smarty->assign('remaining_days', $lang['sections']['main']['remaining_days']);
    } else {
        $config['version_type'] = 'Unlicensed';
        $smarty->assign('remaining_days', '0');
    }

   // $db_connect = new mysqli($dbhost, $dbuser, $dbpasswd, $dbname);

    // Подключаем определитель локации
    require_once(ENGINE_DIR . '/mods/location.php');

    // Функция для получения размера текущей базы данных с единицей измерения
    function getDatabaseSize($database, $dbname) {
        // Проверяем подключение к базе данных
        if (!$database) {
            die("Ошибка подключения к базе данных");
        }

        // SQL-запрос для получения размера базы данных
        $sql = "SELECT table_schema AS `Database`, 
                       ROUND(SUM(data_length + index_length) / 1024 / 1024, 2) AS `Size (MB)` 
                FROM information_schema.TABLES 
                WHERE table_schema = :dbname 
                GROUP BY table_schema";

        try {
            // Выполняем запрос через Medoo
            $result = $database->query($sql, [
                ':dbname' => $dbname
            ])->fetch();

            if ($result) {
                $size_in_mb = $result['Size (MB)'];
                $unit = 'MB'; // Единица измерения по умолчанию

                // Конвертируем в GB, если размер больше 1024 MB
                if ($size_in_mb > 1024) {
                    $size = $size_in_mb / 1024;
                    $unit = 'GB';
                } else {
                    $size = $size_in_mb;
                }

                return [
                    'size' => round($size, 2),
                    'unit' => $unit
                ];
            }
        } catch (Exception $e) {
            die("Ошибка выполнения запроса: " . $e->getMessage());
        }

        return ['size' => 0, 'unit' => 'MB']; // Возвращаем 0 в случае ошибки
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['form_id']) && $_POST['form_id'] === 'deleteCache') {
            $redirect_url = $_POST['delete_current_url'];
            $templates_c_folder = $_SERVER['DOCUMENT_ROOT'] . '/templates_c';
            require_once(ENGINE_DIR . '/mods/delete_directory.php');
            
            // Вызов функции для удаления директории
            deleteDirectory($templates_c_folder);
            
            // Перенаправление после успешного удаления
            header("Location: " . $redirect_url);
            exit(); // Завершение скрипта после перенаправления
        }
    }    

  /*  // Проверяем соединение
    if ($db_connect->connect_error) {
        die("Ошибка подключения: " . $db_connect->connect_error);
    }*/

    // Получение размера базы данных
   // $databaseSizeData = getDatabaseSize($db_connect, $dbname);

    $enabledDatabase = $config["database_settings"]["enabled_database"];
    $currentDatabaseSettings = $config["database_settings"][$enabledDatabase];

    if ($enabledDatabase == "mysql") {
        $databaseSizeData = getDatabaseSize($db_connect, $currentDatabaseSettings["database"]);
        $databaseSize = $databaseSizeData['size'];
        $databaseSizeUnit = $databaseSizeData['unit'];
    } else if ($enabledDatabase == "pgsql") {
        $query = "SELECT pg_size_pretty(pg_database_size(current_database())) AS size";
        $result = $db_connect->query($query)->fetch();
        $databaseSize = $result['size'];
        $databaseSizeUnit = $result['unit'] ?? "";
    }

    // Устанавливаем массив переменных в Smarty
    $smarty->assign('databaseSize', $databaseSize);
    $smarty->assign('progressdatabaseSize', 'style="width: calc(' . $databaseSize . '*10%)"');
    $smarty->assign('databaseSizeUnit', $databaseSizeUnit);

    // Определяем вес папки Smarty с кешем
    $calculation_folder = $_SERVER['DOCUMENT_ROOT'] . '/templates_c';
    require_once(ENGINE_DIR . '/mods/directory_size.php');
    $smarty->assign('directorysize', $formattedSize);
    $smarty->assign('progressdirectorysize', 'style="width: calc(' . $formattedSize . '*10%)"');