<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['extension'])) {
        $extension = $_POST['extension'];
        // Проверяем, существует ли модуль в конфигурации
        if (isset($config['extensions'][$extension])) {
            // Устанавливаем модуль
            $config['extensions'][$extension]['enabled'] = true;
            // Обновление данных в $config

            if ($extension == "grades" || $extension == "student_progress" || $extension == "schedules") {
                require_once ENGINE_DIR . "/extensions/education/$extension/install.php";
            } else {
                require_once ENGINE_DIR . "/extensions/$extension/install.php";
            }

            require_once(ENGINE_DIR . '/mods/update_config.php');

            // Удаляем папку Smarty кеша
            $templates_c_folder = $_SERVER['DOCUMENT_ROOT'] . '/templates_c';
            require_once(ENGINE_DIR . '/mods/delete_directory.php');
            deleteDirectory($templates_c_folder);

            // Перенаправляем обратно на страницу управления модулями
            header('Location: /admin?action=managing-extensions');
            exit;
        } else {
            echo "Ошибка: Модуль не найден.";
        }
    }

    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['deactivate_extension'])) {
        $extension = $_POST['deactivate_extension'];
        // Проверяем, существует ли модуль в конфигурации
        if (isset($config['extensions'][$extension])) {
            // Устанавливаем модуль
            $config['extensions'][$extension]['enabled'] = false;
            // Обновление данных в $config

            if ($extension == "grades" || $extension == "student_progress" || $extension == "schedules") {
                require_once ENGINE_DIR . "/extensions/education/$extension/uninstall.php";
            } else {
                require_once(ENGINE_DIR."/extensions/$extension" . '/uninstall.php');
            }

            require_once(ENGINE_DIR . '/mods/update_config.php');

            // Удаляем папку Smarty кеша
            $templates_c_folder = $_SERVER['DOCUMENT_ROOT'] . '/templates_c';
            require_once(ENGINE_DIR . '/mods/delete_directory.php');
            deleteDirectory($templates_c_folder);

            // Перенаправляем обратно на страницу управления модулями
            header('Location: /admin?action=managing-extensions');
            exit;
        } else {
            echo "Ошибка: Модуль не найден.";
        }
    }

    $smarty->assign("extensions", $config["extensions"]);

    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['nav']['extensionslink'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['nav']['extensionslink'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);