<?php
        /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['module'])) {
        $module = $_POST['module'];
        // Проверяем, существует ли модуль в конфигурации
        if (isset($config['modules'][$module])) {
            // Устанавливаем модуль
            $config['modules'][$module]['used'] = true;
            // Обновление данных в $config
            require_once(ENGINE_DIR . '/mods/update_config.php');
            require_once($controllerDir . '/' . $module . '/install.php');
            
            // Удаляем папку Smarty кеша
            $templates_c_folder = $_SERVER['DOCUMENT_ROOT'] . '/templates_c';
            require_once(ENGINE_DIR . '/mods/delete_directory.php');
            deleteDirectory($templates_c_folder);

            // Перенаправляем обратно на страницу управления модулями
            header('Location: /admin?action=modules');
            exit;
        } else {
            echo "Ошибка: Модуль не найден.";
        }
    }

    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['nav']['moduleslink'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active">' . $lang['nav']['moduleslink'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);