<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    // Проверка, была ли отправлена форма для удаления страницы
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_page_id'])) {
        $page_id = $_POST['delete_page_id'];

        // Выполняем запрос для удаления страницы с использованием Medoo
        $db_connect->delete('ads', [
            'id' => $page_id
        ]);

        header("Location: /admin?action=modules/ads/list");
        exit();
    }

    // Выполняем запрос для получения полного списка объявлений с использованием Medoo
    $ads = $db_connect->select('ads', '*');

    // Получаем alt_names для каждой категории и формируем ассоциативный массив
    $categoriesAltNames = [];
    $categories = $db_connect->select('ads_categories', ['name', 'alt_name']);
    foreach ($categories as $category) {
        $categoriesAltNames[$category['name']] = $category['alt_name'];
    }
    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });

    require_once ENGINE_DIR . '/mods/get_module_categories.php';
    // Формируем данные для отображения
    foreach ($ads as &$ad) {
        $ad[$lang["datatable"]["category"]] = getCategoriesString($ad['id'], "ads");
        $ad[$lang["datatable"]["date"]] = $ad["date"];
        $ad[$lang["datatable"]["author"]] = $ad["autor"];
        $ad[$lang["datatable"]["views"]] = $ad["views"];
        $ad['category_names'] = $categories;

        $ad[$lang["datatable"]["title"]] = "<a target='_blank' href='/ads/{$ad["alt_name"]}?lang={$ad['language']}'>" . $ad["title"] . "</a>";
        $ad[$lang["datatable"]["lang"]] = "<img src='/engine/lang/{$ad['language']}/icon.png' style='height: 22px;' alt=''>";
        $ad[$lang["datatable"]["actions"]] = "<a href='/admin?action=modules/ads/edit&id={$ad['id']}' class='mx-1 top-1'><i class='fa fa-edit'></i></a>
                                <form method='POST' action='/admin?action=modules/ads/list' style='display:inline;'>
                                    <input type='hidden' name='delete_page_id' value='{$ad['id']}'>
                                    <button type='submit' class='no-b mx-1' onclick='return confirm(`Вы уверены, что хотите удалить это объявление?`);'>
                                        <i class='fa fa-trash'></i>
                                    </button>
                                </form>";
    }

    // Устанавливаем массив переменных в Smarty
    $smarty->assign('ads', $ads);
    $yourData = array('title' => $lang['nav']['adslist'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
            <li class="breadcrumb-item active">' . $lang['nav']['adslist'] . '</li>
        ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);
?>
