<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    $module_entity = 'lots';

    // Сбрасываем счетчик автоинкремента к максимальному значению id
    require_once(ENGINE_DIR . '/mods/autoincrement.php');
    list($page_id, $max_id) = resetAutoIncrement($db_connect, $module_entity);

    // Проверяем соединение
    if ($db_connect->connect_error) {
        die("Ошибка подключения: " . $db_connect->connect_error);
    }
        
    // Подключаем файл проверки зарезервированных URL и запрещённых символов
    require_once(SYSTEM_DIR . '/plugins/reserved_urls.php');

    // Получаем категории
    $categories = [];
    $sql = "SELECT id, parentid, name FROM lots_categories ORDER BY name ASC";
    $result = $db_connect->query($sql);
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $categories[] = $row;
        }
    }

    // Инициализация сообщения об ошибке
    $error_message = '';
    
    // Обработка формы добавления пользователя
    if (isset($_POST['addlot'])) {
        $folder = $_POST['folder'] ?? '';
        $p_id = $_POST['p_id'] ?? '';
        
        // Подготовка запроса на добавление в таблицу lots_field_values
        $x_values = isset($_POST['x_value']) ? implode(', ', $_POST['x_value']) : '';
        $field_ids = $_POST['field_ids'] ?? [];
        $lots_id = $p_id;
        
        // Проверка загруженного изображения (не в редакторе)
        require_once(ENGINE_DIR . '/mods/check_upload_image.php');
		
		// Получаем данные из формы
        $autor = isset($_POST['autor']) ? strip_tags(trim($_POST['autor'])) : '';
        $date = isset($_POST['date']) && !empty($_POST['date']) ? strip_tags(trim($_POST['date'])) : date($config['date_format']);
        $category = isset($_POST['category']) ? (is_array($_POST['category']) ? implode(', ', $_POST['category']) : $_POST['category']) : '';
        $language = isset($_POST['language']) ? (is_array($_POST['language']) ? implode(', ', $_POST['language']) : $_POST['language']) : '';
        $title = strip_tags(trim($_POST['title']));
        $alt_name = strip_tags(trim($_POST['alt_name']));
        $short_desc = htmlspecialchars($_POST['short_desc'], ENT_QUOTES);
		$full_desc = htmlspecialchars($_POST['full_desc'], ENT_QUOTES);
        
        $start_date = isset($_POST['start_date']) && !empty($_POST['start_date']) ? strip_tags(trim($_POST['start_date'])) : date($config['date_format']);
        $end_date = isset($_POST['end_date']) && !empty($_POST['end_date']) ? strip_tags(trim($_POST['end_date'])) : date($config['date_format']);
        $capacity = isset($_POST['capacity']) ? (is_array($_POST['capacity']) ? implode(', ', $_POST['capacity']) : $_POST['capacity']) : '';
        $status = isset($_POST['status']) ? (is_array($_POST['status']) ? implode(', ', $_POST['status']) : $_POST['status']) : '';

		$meta_desc = strip_tags(trim($_POST['meta_desc']));
		$meta_keys = strip_tags(trim($_POST['meta_keys']));
        $views = isset($_POST['views']) ? intval($_POST['views']) : 0;

        // Проверяем, было ли загружено изображение
        if (empty($image)) {$error_message .= "Изображение не загружено.<br>";}
        // Проверяем, содержит ли URL запрещённые символы
        $forbidden_char_found = containsForbiddenChars($alt_name, $reserved_urls['forbidden_chars']); // Проверяем без преобразования в нижний регистр
        if ($forbidden_char_found) {
            // Если найден запрещённый символ, создаём сообщение об ошибке
            $error_message = "Ошибка: URL содержит запрещённый символ: '{$forbidden_char_found}'.";
            $smarty->assign('error_message', $error_message);
        }
        // Преобразуем URL в нижний регистр для проверки на зарезервированные значения
        elseif (array_key_exists(strtolower($alt_name), $reserved_urls)) {
            // Если URL зарезервирован, создаём сообщение об ошибке
            $error_message = "Ошибка: " . $reserved_urls[strtolower($alt_name)];
            $smarty->assign('error_message', $error_message);
        } elseif (empty($error_message)) {
            // Выполняем запрос на добавление лота в базу данных
            $insertQuery = "INSERT INTO lots"; 
            $insertQuery .= "(autor, date, category, language, title, image, alt_name, short_desc, full_desc, start_date, end_date, capacity, status, meta_desc, meta_keys, views) VALUES ('$autor', '$date', '$category', '$language', '$title', '$image', '$alt_name', '$short_desc', '$full_desc', '$start_date', '$end_date', '$capacity', '$status', '$meta_desc', '$meta_keys', '$views')";
            // Выполнение запроса
            $result = $db_connect->query($insertQuery);
            // Добавляем в базу данные для каждого дополнительного поля
            if (!empty($field_ids)) {
                foreach ($field_ids as $field_id) {
                    // Проверяем, существует ли значение для данного поля
                    if (!empty($_POST['x_value'][$field_id])) {
                        $x_value = $db_connect->real_escape_string($_POST['x_value'][$field_id]);
                        resetAutoIncrement($db_connect, 'lots_field_values');
                        // Выполняем вставку в таблицу
                        $insertField = "INSERT INTO lots_field_values (lots_id, field_id, x_value) 
                                        VALUES ('$lots_id', '$field_id', '$x_value')";
                        if (!$db_connect->query($insertField)) {
                            $error_message .= "Ошибка при добавлении доп. поля с ID $field_id: " . $db_connect->error . "<br>";
                        }
                    }
                }
            }
            // Проверяем результат выполнения запроса
            if ($result) {
                // Перенаправление на ту же страницу после добавления
                header("Location: /admin?action=lots/list");
                exit();
            } else {
                $error_message .= "Ошибка при добавлении файла: " . $db_connect->error . "<br>";
            }
        }
    }

    // Подключаем дополнительные поля
    require_once(SYSTEM_DIR . '/plugins/extra_fields.php');
    
    // Закрываем соединение с базой данных
    $db_connect->close();
    
    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['nav']['addlots'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active"><a href="/admin?action=lots/list">' . $lang['topmenu']['lots'] . '</a></li>
        <li class="breadcrumb-item active">' . $lang['nav']['addlots'] . '</li>
    ');
    $smarty->assign('add_page', 'add_page');
	$smarty->assign('page_id', $page_id);
    $smarty->assign('max_id', $max_id + 1);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);
    $smarty->assign('categories', $categories);
    $smarty->assign('error_message', $error_message);