<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Подключение к базе данных
    require_once(ENGINE_DIR . '/data/config.php');

    // Получение всех категорий
    $sql = "SELECT * FROM coupons_categories";
    $result = mysqli_query($db_connect, $sql);

    if (!$result) {
        die('Ошибка выполнения запроса: ' . mysqli_error($db_connect));
    }

    // Сбрасываем счетчик автоинкремента к максимальному значению id
    require_once(ENGINE_DIR . '/mods/autoincrement.php');
    list($page_id, $max_id) = resetAutoIncrement($db_connect, 'coupons_categories');

    $categories = array();
    $parent_categories = array();
    while ($row = mysqli_fetch_assoc($result)) {
        $categories[] = $row; // Все категории для отображения
        // Добавляем только те категории, которые могут быть родительскими
        if ($row['parentid'] == 0) {
            $parent_categories[] = $row;
        }
    }

    // Передача уникального ключа для добавления/удаления категорий
    if (!isset($_SESSION['category_form_key'])) {
        $_SESSION['category_form_key'] = uniqid();
    }

    // Проверка запроса на добавление категории
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_category'])) {
        if (isset($_POST['form_key']) && $_POST['form_key'] === $_SESSION['category_form_key']) {
            $name = mysqli_real_escape_string($db_connect, $_POST['name']);
            $alt_name = mysqli_real_escape_string($db_connect, $_POST['alt_name']);
            $language = mysqli_real_escape_string($db_connect, $_POST['language']);
            $parentid = intval($_POST['parentid']);
            // Установка позиции
            if ($parentid === 0) {
                // Получение максимальной позиции для всех категорий без родителя
                $sql_max_position = "SELECT MAX(position) AS max_position FROM coupons_categories WHERE parentid = 0";
                $result_max_position = mysqli_query($db_connect, $sql_max_position);
                $row_max_position = mysqli_fetch_assoc($result_max_position);
                // Установка позиции в 1 больше максимальной
                $position = $row_max_position['max_position'] ? $row_max_position['max_position'] + 1 : 1;
            } else {
                // Получение максимальной позиции для родительской категории
                $sql_max_position = "SELECT MAX(position) AS max_position FROM coupons_categories WHERE parentid = ?";
                $stmt_max_position = mysqli_prepare($db_connect, $sql_max_position);
                mysqli_stmt_bind_param($stmt_max_position, "i", $parentid);
                mysqli_stmt_execute($stmt_max_position);
                $result_max_position = mysqli_stmt_get_result($stmt_max_position);
                $row_max_position = mysqli_fetch_assoc($result_max_position);
                // Установка позиции в 1 больше максимальной
                $position = $row_max_position['max_position'] ? $row_max_position['max_position'] + 1 : 1;
            }
            // Подготовка SQL запроса
            $sql = "INSERT INTO coupons_categories (name, alt_name, language, parentid, position) VALUES (?, ?, ?, ?, ?)";
            $stmt = mysqli_prepare($db_connect, $sql);
            // Проверка, успешно ли подготовлен запрос
            if ($stmt) {
                mysqli_stmt_bind_param($stmt, "ssssi", $name, $alt_name, $language, $parentid, $position);
                if (mysqli_stmt_execute($stmt)) {
                    unset($_SESSION['category_form_key']);
                    header("Location: {$_SERVER['REQUEST_URI']}&success=added");
                    exit();
                } else {
                    die('Ошибка добавления категории: ' . mysqli_error($db_connect));
                }
            } else {
                die('Ошибка подготовки запроса: ' . mysqli_error($db_connect)); // Вывод сообщения об ошибке
            }
        } else {
            die('Ошибка: неверный ключ формы.');
        }
    }

    // Проверка запроса на удаление категории
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete_coupons_category'])) {
        if (isset($_POST['form_key']) && $_POST['form_key'] === $_SESSION['category_form_key']) {
            $id = intval($_POST['id']);
            $sql = "DELETE FROM coupons_categories WHERE id = ?";
            $stmt = mysqli_prepare($db_connect, $sql);
            mysqli_stmt_bind_param($stmt, "i", $id);
            if (mysqli_stmt_execute($stmt)) {
                unset($_SESSION['category_form_key']);
                header("Location: {$_SERVER['REQUEST_URI']}&success=deleted");
                exit();
            } else {
                die('Ошибка удаления категории: ' . mysqli_error($db_connect));
            }
        } else {
            die('Ошибка: неверный ключ формы.');
        }
    }

    // Уведомления об успехе
    if (isset($_GET['success'])) {
        if ($_GET['success'] == 'deleted') {
            $smarty->assign('successMessage', 'Категория успешно удалена.');
        } elseif ($_GET['success'] == 'added') {
            $smarty->assign('successMessage', 'Категория успешно добавлена.');
        } elseif ($_GET['success'] == 'edited') {
            $smarty->assign('successMessage', 'Категория успешно отредактирована.');
        }
    }

    // Передача данных в шаблон
    $smarty->assign('form_key', $_SESSION['category_form_key']);
    $smarty->assign('categories', $categories);
    $smarty->assign('parent_categories', $parent_categories);
    $yourData = array('title' => $lang['nav']['couponscategories'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active"><a href="/admin?action=coupons/list">' . $lang['topmenu']['coupons'] . '</a></li>
        <li class="breadcrumb-item active">' . $lang['nav']['couponscategories'] . '</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);