<?php
    /*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    $module_entity = 'coupons';

    $action = isset($_GET['action']) ? $_GET['action'] : 'main';
    $categories = [];
    $result = $db_connect->select("coupons_categories", "*") ?? [];
    if (!empty($result["id"])) {
        $categories[] = $result;
    } else {
        foreach ($result as $row) {
            $categories[] = $row;
        }
    }

    if ($_SERVER["REQUEST_METHOD"] == "POST" && $action == 'coupons/edit') {
        // Обработка POST-запроса для сохранения изменений страницы
        if (isset($_POST['page_id'])) {
            $page_id = $_POST['page_id'];
            $folder = $_POST['folder'] ?? '';
            $p_id = $_POST['p_id'] ?? '';

            // Подготовка запроса на добавление в таблицу coupons_field_values
            $x_values = isset($_POST['x_value']) ? implode(', ', $_POST['x_value']) : '';
            $field_ids = $_POST['field_ids'] ?? [];
            $coupons_id = $page_id;

            // Добавляем в базу данные для каждого дополнительного поля
            if (!empty($field_ids)) {
                foreach ($field_ids as $field_id) {
                    if (!empty($_POST['x_value'][$field_id])) {
                        $insertField = $db_connect->insert("coupons_field_values", [
                            "coupons_id" => $coupons_id,
                            "field_id" => $field_id,
                            "x_value" => $_POST['x_value'][$field_id]
                        ]);
                    }
                }
            }

            $stmt = $db_connect->update("coupons", [
                "start_at" => $_POST['start_at'],
                "end_at" => $_POST['end_at'],
                "code" => $_POST['code'],
                "discount_type" => $_POST['discount_type'],
                "discount_value" => $_POST['discount_value'],
                "apply_to_all" => $_POST['apply_to_all'],
                "status" => $_POST['status'],
                "min_order_sum" => $_POST['min_order_sum'],
                "max_discount_sum" => $_POST['max_discount_sum'],
                "usage_limit" => $_POST['usage_limit'],
                "usage_limit_per_user" => $_POST['usage_limit_per_user'],
                "description" => $_POST['description'],
            ], ["id" => $page_id]);

            $db_connect->delete("coupons_cat_relations", ["coupons_id" => (int)$coupons_id]);

            if (!empty($_POST["category"])) {
                foreach ($_POST["category"] as $categoryId) {
                    $db_connect->insert("coupons_cat_relations", [
                        "coupons_id" => (int)$coupons_id,
                        "category_id" => (int)$categoryId,
                    ]);
                }
            }


            if ($stmt) {
                header("Location: /admin?action=coupons/list");
                exit();
            } else {
                echo "Ошибка подготовки запроса: " . mysqli_error($db_connect);
                exit();
            }


        } else {
            echo "Ошибка: ID страницы не указан.";
            exit();
        }
    } elseif ($_SERVER["REQUEST_METHOD"] == "GET" && $action == 'coupons/edit') {
        // Обработка GET-запроса для отображения страницы редактирования
        if (isset($_GET['id'])) {
            $page_id = $_GET['id'];
            // Подключаем дополнительные поля
            require_once(SYSTEM_DIR . '/plugins/extra_fields.php');
            require_once ENGINE_DIR.'/mods/get_module_categories.php';

            $stmt = $db_connect->select("coupons", "*", ["id" => $page_id]);

            if ($stmt) {
                $result = $stmt;
                if ($result) {
                    $page = $result[0];
                    $smarty->assign('page', $page);
                    $selectedCategories = getCategoriesIds($page["id"], "coupons");
                    $smarty->assign('selectedCategories', $selectedCategories);

                    $selectedLanguages = explode(", ", $page['language']);
                    $smarty->assign('selectedLanguages', $selectedLanguages);
                } else {
                    echo "Ошибка: Страница не найдена.";
                    exit();
                }
            } else {
                // В случае ошибки выводим сообщение
                echo "Ошибка подготовки запроса: " . mysqli_error($db_connect);
                exit();
            }
        } else {
            // Если запрос не был отправлен методом GET или отсутствует параметр id, выводим сообщение об ошибке
            echo "Ошибка: Доступ запрещен.";
            exit();
        }
    }
    $smarty->assign('categories', $categories);

    // Устанавливаем массив переменных в Smarty
    $smarty->assign('add_page', 'add_page');
    $smarty->assign('page_id', $page_id);
    $smarty->assign('stmt', $stmt);
    $yourData = array('title' => $lang['nav']['addedit'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
            <li class="breadcrumb-item active"><a href="/admin?action=coupons/list">Объявления</a></li>
            <li class="breadcrumb-item active">Редактирование объявления</li>
        ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);