<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    $module_entity = 'coupons';



    // Подключаем файл проверки зарезервированных URL и запрещённых символов
    require_once(SYSTEM_DIR . '/plugins/reserved_urls.php');

    // Получаем категории
    $categories = [];
    $result = $db_connect->select("coupons_categories", "*") ?? [];
    foreach ($result as $row) {
        $categories[] = $row;
    }

    // Инициализация сообщения об ошибке
    $error_message = '';

    // Обработка формы добавления объявления
    if (isset($_POST['addcoupon'])) {
        $folder = $_POST['folder'] ?? '';
        $p_id = (int)$db_connect->max("coupons", "id") + 1;

        // Подготовка запроса на добавление в таблицу coupons_field_values
        $x_values = isset($_POST['x_value']) ? implode(', ', $_POST['x_value']) : '';
        $field_ids = $_POST['field_ids'] ?? [];
        $coupons_id = $p_id;

        $result = $db_connect->insert("coupons", [
            "start_at" => $_POST['start_at'],
            "end_at" => $_POST['end_at'],
            "code" => $_POST['code'],
            "discount_type" => $_POST['discount_type'],
            "discount_value" => $_POST['discount_value'],
            "apply_to_all" => $_POST['apply_to_all'],
            "status" => $_POST['status'],
            "min_order_sum" => $_POST['min_order_sum'],
            "max_discount_sum" => $_POST['max_discount_sum'],
            "usage_limit" => $_POST['usage_limit'],
            "usage_limit_per_user" => $_POST['usage_limit_per_user'],
            "description" => $_POST['description'],
            /*"email" => $email,
            "views" => $views*/
        ]);

    }


    $coupons_id = $db_connect->id();

    if (!empty($_POST["category"])) {
        foreach ($_POST["category"] as $categoryId) {
            $db_connect->insert("coupons_cat_relations", [
                "coupons_id" => (int)$coupons_id,
                "category_id" => (int)$categoryId,
            ]);
        }
    }

    require_once ENGINE_DIR . '/mods/access_control.php';
    saveAccessSettings((int)$coupons_id, "coupons", $_POST["exclude_locations"] ?? [], $_POST["include_locations"] ?? [], $_POST["groups"]);

    if (!empty($field_ids)) {
        foreach ($field_ids as $field_id) {
            if (!empty($_POST['x_value'][$field_id])) {
                $insertField = $db_connect->insert("coupons_field_values", [
                    "coupons_id" => $coupons_id,
                    "field_id" => $field_id,
                    "x_value" => $_POST['x_value'][$field_id]
                ]);
            }
        }
    }
    // Проверяем результат выполнения запроса
    if ($result) {
        // Перенаправление на ту же страницу после добавления
        header("Location: /admin?action=modules/coupons/list");
        exit();
    } else {
        $error_message .= "Ошибка при добавлении файла: " . $db_connect->error . "<br>";
    }

    // Подключаем дополнительные поля
    require_once(SYSTEM_DIR . '/plugins/extra_fields.php');
    $groups = $db_connect->select("roles", "*") ?? [];
    $smarty->assign('groups', $groups);

    // Закрываем соединение с базой данных
    $lastRow = $db_connect->get("coupons", ['id'], [
        "ORDER" => ["id" => "DESC"] // Сортировка по убыванию id
    ]);
    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['nav']['addcoupons'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
            <li class="breadcrumb-item active"><a href="/admin?action=coupons/list">Объявления</a></li>
            <li class="breadcrumb-item active">' . $lang['nav']['addcoupons'] . '</li>
        ');
    $smarty->assign('add_page', 'add_page');
    $smarty->assign('page_id', $lastRow["id"] ?? 0 + 1);
    $smarty->assign('max_id', 0 + 1);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);
    $smarty->assign('categories', $categories);
    $smarty->assign('error_message', ""); //todo: ??