<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    // Проверка, была ли отправлена форма для удаления страницы
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_page_id'])) {
        $page_id = $_POST['delete_page_id'];

        $db_connect->delete("coupons", ["id" => $page_id]);
        
        header("Location: /admin?action=modules/coupons/list");
        exit();
    }

    // Выполняем запрос для получения полного списка объявлений с использованием Medoo
    $coupons = $db_connect->select('coupons', '*');

    // Получаем alt_names для каждой категории и формируем ассоциативный массив
    $categoriesAltNames = [];
    $categories = $db_connect->select('coupons_categories', ['name', 'alt_name']);
    foreach ($categories as $category) {
        $categoriesAltNames[$category['name']] = $category['alt_name'];
    }
    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });

    require_once ENGINE_DIR . '/mods/get_module_categories.php';
    // Формируем данные для отображения
    foreach ($coupons as &$ad) {
        $ad['category'] = getCategoriesString($ad['id'], "coupons");


        /*    $ad['category_alt_names'] = implode(',', $altNames);
            $ad['category_links'] = array_map(function ($altName) {
                return "/ac/{$altName}";
            }, $altNames);*/
        $ad['category_names'] = $categories;
        $ad["code"] = "<a target='_blank' href='/coupons/{$ad["id"]}'>" . $ad["code"] . "</a>";
        $ad["lang"] = "<img src='/engine/lang/{$ad['language']}/icon.png' style='height: 22px;' alt=''>";
        $ad["actions"] = "<a href='/admin?action=modules/coupons/edit&id={$ad['id']}' class='mx-1 top-1'><i class='fa fa-edit'></i></a>
                                    <form method='POST' action='/admin?action=modules/coupons/list' style='display:inline;'>
                                        <input type='hidden' name='delete_page_id' value='{$ad['id']}'>
                                        <button type='submit' class='no-b mx-1' onclick='return confirm(`Вы уверены, что хотите удалить это объявление?`);'>
                                            <i class='fa fa-trash'></i>
                                        </button>
                                    </form>";
    }

    // Устанавливаем массив переменных в Smarty
    $smarty->assign('coupons', $coupons);
    $yourData = array('title' => $lang['nav']['couponslist'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
                <li class="breadcrumb-item active">' . $lang['nav']['couponslist'] . '</li>
            ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);