<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    $module_entity = 'events';

    // Сбрасываем счетчик автоинкремента к максимальному значению id
    require_once(ENGINE_DIR . '/mods/autoincrement.php');

    // Подключаем файл проверки зарезервированных URL и запрещённых символов
    require_once(SYSTEM_DIR . '/plugins/reserved_urls.php');

    // Получаем категории
    $categories = [];
    $result = $db_connect->select("events_categories", "*") ?? [];
    if (!empty($result["id"])) {
        $categories[] = $result;
    } else {
        foreach ($result as $row) {
            $categories[] = $row;
        }
    }

    // Инициализация сообщения об ошибке
    $error_message = '';
    
    // Обработка формы добавления пользователя
    if (isset($_POST['addevent'])) {
        $folder = $_POST['folder'] ?? '';
        $p_id = (int)$db_connect->max("events", "id") + 1;
        
        // Подготовка запроса на добавление в таблицу events_field_values
        $x_values = isset($_POST['x_value']) ? implode(', ', $_POST['x_value']) : '';
        $field_ids = $_POST['field_ids'] ?? [];
        $events_id = $p_id;
        
        // Проверка загруженного изображения (не в редакторе)
        require_once(ENGINE_DIR . '/mods/check_upload_image.php');
		
		// Получаем данные из формы
        $autor = isset($_POST['autor']) ? strip_tags(trim($_POST['autor'])) : '';
        $date = isset($_POST['date']) && !empty($_POST['date']) ? strip_tags(trim($_POST['date'])) : date($config['date_format']);
        $category = isset($_POST['category']) ? (is_array($_POST['category']) ? implode(', ', $_POST['category']) : $_POST['category']) : '';
        $language = isset($_POST['language']) ? (is_array($_POST['language']) ? implode(', ', $_POST['language']) : $_POST['language']) : '';
        $title = strip_tags(trim($_POST['title']));
        $alt_name = strip_tags(trim($_POST['alt_name']));
        $short_desc = htmlspecialchars($_POST['short_desc'], ENT_QUOTES);
		$full_desc = htmlspecialchars($_POST['full_desc'], ENT_QUOTES);
        
        $start_date = isset($_POST['start_date']) && !empty($_POST['start_date']) ? strip_tags(trim($_POST['start_date'])) : date($config['date_format']);
        $end_date = isset($_POST['end_date']) && !empty($_POST['end_date']) ? strip_tags(trim($_POST['end_date'])) : date($config['date_format']);
        $location = isset($_POST['location']) ? (is_array($_POST['location']) ? implode(', ', $_POST['location']) : $_POST['location']) : '';
        $capacity = isset($_POST['capacity']) ? (is_array($_POST['capacity']) ? implode(', ', $_POST['capacity']) : $_POST['capacity']) : '';
        $status = isset($_POST['status']) ? (is_array($_POST['status']) ? implode(', ', $_POST['status']) : $_POST['status']) : '';
        $performers = isset($_POST['performers']) ? (is_array($_POST['performers']) ? implode(', ', $_POST['performers']) : $_POST['performers']) : '';

		$meta_desc = strip_tags(trim($_POST['meta_desc']));
		$meta_keys = strip_tags(trim($_POST['meta_keys']));
        $views = isset($_POST['views']) ? intval($_POST['views']) : 0;

        // Проверяем, было ли загружено изображение
        if (empty($image)) {$error_message .= "Изображение не загружено.<br>";}
        // Проверяем, содержит ли URL запрещённые символы
        $forbidden_char_found = containsForbiddenChars($alt_name, $reserved_urls['forbidden_chars']); // Проверяем без преобразования в нижний регистр
        if ($forbidden_char_found) {
            // Если найден запрещённый символ, создаём сообщение об ошибке
            $error_message = "Ошибка: URL содержит запрещённый символ: '{$forbidden_char_found}'.";
            $smarty->assign('error_message', $error_message);
        }
        // Преобразуем URL в нижний регистр для проверки на зарезервированные значения
        elseif (array_key_exists(strtolower($alt_name), $reserved_urls)) {
            // Если URL зарезервирован, создаём сообщение об ошибке
            $error_message = "Ошибка: " . $reserved_urls[strtolower($alt_name)];
            $smarty->assign('error_message', $error_message);
        } elseif (empty($error_message)) {
            $result = $db_connect->insert("events", [
                "autor" => $autor,
                "date" => $date,
                "language" => $language,
                "title" => $title,
                "image" => $image,
                "alt_name" => $alt_name,
                "short_desc" => $short_desc,
                "full_desc" => $full_desc,
                "start_date" => $start_date,
                "end_date" => $end_date,
                "location" => $location,
                "capacity" => $capacity,
                "status" => $status,
                "performers" => $performers,
                "meta_desc" => $meta_desc,
                "meta_keys" => $meta_keys,
                "views" => $views,
                "price" => 0
            ]);

            $events_id = $db_connect->id();

            if (!empty($_POST["category"])) {
                foreach ($_POST["category"] as $categoryId) {
                    $db_connect->insert("events_cat_relations", [
                        "events_id" => (int)$events_id,
                        "category_id" => (int)$categoryId,
                    ]);
                }
            }

            require_once ENGINE_DIR . '/mods/access_control.php';
            saveAccessSettings((int)$events_id, "events", $_POST["exclude_locations"] ?? [], $_POST["include_locations"] ?? [], $_POST["groups"]);

            if (!empty($field_ids)) {
                foreach ($field_ids as $field_id) {
                    if (!empty($_POST['x_value'][$field_id])) {
                        $insertField = $db_connect->insert("events_field_values", [
                            "events_id" => $events_id,
                            "field_id" => $field_id,
                            "x_value" => $_POST['x_value'][$field_id]
                        ]);
                    }
                }
            }
            // Проверяем результат выполнения запроса
            if ($result) {
                // Перенаправление на ту же страницу после добавления
                header("Location: /admin?action=modules/events/list");
                exit();
            } else {
                $error_message .= "Ошибка при добавлении файла: " . $db_connect->error . "<br>";
            }
        }
    }

    // Подключаем дополнительные поля
    require_once(SYSTEM_DIR . '/plugins/extra_fields.php');

    $groups = $db_connect->select("roles", "*") ?? [];
    $smarty->assign('groups', $groups);

    $lastRow = $db_connect->get("events", ['id'], [
        "ORDER" => ["id" => "DESC"] // Сортировка по убыванию id
    ]);
    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['nav']['addevents'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('POST', $_POST);
    $_POST = [];
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active"><a href="/admin?action=events/list">Мероприятия</a></li>
        <li class="breadcrumb-item active">' . $lang['nav']['addevents'] . '</li>
    ');
    $smarty->assign('add_page', 'add_page');
	$smarty->assign('page_id', $lastRow["id"] ?? 0 + 1);
    $smarty->assign('max_id', 0 + 1);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);
    $smarty->assign('categories', $categories);
    $smarty->assign('error_message', $error_message);