<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    $module_entity = 'events';

    $action = isset($_GET['action']) ? $_GET['action'] : 'main';

    $categories = [];
    $result = $db_connect->select("events_categories", "*") ?? [];
    if (!empty($result["id"])) {
        $categories[] = $result;
    } else {
        foreach ($result as $row) {
            $categories[] = $row;
        }
    }

    if ($_SERVER["REQUEST_METHOD"] == "POST" && $action == 'modules/events/edit') {
        // Обработка POST-запроса для сохранения изменений страницы
        if (isset($_POST['page_id'])) {
            $page_id = $_POST['page_id'];
            $folder = $_POST['folder'] ?? '';
            $p_id = $_POST['p_id'] ?? '';
        
            // Подготовка запроса на добавление в таблицу events_field_values
            $x_values = isset($_POST['x_value']) ? implode(', ', $_POST['x_value']) : '';
            $field_ids = $_POST['field_ids'] ?? [];
            $events_id = $page_id;

            // Добавляем в базу данные для каждого дополнительного поля
            if (!empty($field_ids)) {
                foreach ($field_ids as $field_id) {
                    if (!empty($_POST['x_value'][$field_id])) {
                        $insertField = $db_connect->insert("events_field_values", [
                            "events_id" => $events_id,
                            "field_id" => $field_id,
                            "x_value" => $_POST['x_value'][$field_id]
                        ]);
                    }
                }
            }
            
            // Проверка загруженного изображения (не в редакторе)
            require_once(ENGINE_DIR . '/mods/check_upload_image.php');
            
            $date = isset($_POST['date']) && !empty($_POST['date']) ? strip_tags(trim($_POST['date'])) : date($config['date_format']);
            $autor = isset($_POST['autor']) ? strip_tags(trim($_POST['autor'])) : '';
            $category = isset($_POST['category']) ? (is_array($_POST['category']) ? implode(', ', $_POST['category']) : $_POST['category']) : '';
            $language = isset($_POST['language']) ? (is_array($_POST['language']) ? implode(', ', $_POST['language']) : $_POST['language']) : '';
            $title = strip_tags(trim($_POST['title']));
            $alt_name = strip_tags(trim($_POST['alt_name']));
            $short_desc = htmlspecialchars($_POST['short_desc'], ENT_QUOTES);
            $full_desc = htmlspecialchars($_POST['full_desc'], ENT_QUOTES);
            
            $start_date = isset($_POST['start_date']) && !empty($_POST['start_date']) ? strip_tags(trim($_POST['start_date'])) : date($config['date_format']);
            $end_date = isset($_POST['end_date']) && !empty($_POST['end_date']) ? strip_tags(trim($_POST['end_date'])) : date($config['date_format']);
            $location = isset($_POST['location']) ? (is_array($_POST['location']) ? implode(', ', $_POST['location']) : $_POST['location']) : '';
            $capacity = isset($_POST['capacity']) ? (is_array($_POST['capacity']) ? implode(', ', $_POST['capacity']) : $_POST['capacity']) : '';
            $status = isset($_POST['status']) ? (is_array($_POST['status']) ? implode(', ', $_POST['status']) : $_POST['status']) : '';
            $performers = isset($_POST['performers']) ? (is_array($_POST['performers']) ? implode(', ', $_POST['performers']) : $_POST['performers']) : '';
            
            $meta_desc = strip_tags(trim($_POST['meta_desc']));
            $meta_keys = strip_tags(trim($_POST['meta_keys']));
            $views = isset($_POST['views']) ? intval($_POST['views']) : 0;

            $stmt = $db_connect->update("events", [
                "date" => $date,
                "autor" => $autor,
                "language" => $language,
                "title" => $title,
                "alt_name" => $alt_name,
                "short_desc" => $short_desc,
                "full_desc" => $full_desc,
                "start_date" => $start_date,
                "end_date" => $end_date,
                "location" => $location,
                "capacity" => $capacity,
                "status" => $status,
                "performers" => $performers,
                "meta_keys" => $meta_keys,
                "meta_desc" => $meta_desc,
            ], ["id" => $events_id]);

            $db_connect->delete("events_cat_relations", ["events_id" => (int)$events_id]);

            if (!empty($_POST["category"])) {
                foreach ($_POST["category"] as $categoryId) {
                    $db_connect->insert("events_cat_relations", [
                        "events_id" => (int)$events_id,
                        "category_id" => (int)$categoryId,
                    ]);
                }
            }

            if ($stmt) {
                header("Location: /admin?action=modules/events/list");
                exit();
            } else {
                echo "Ошибка подготовки запроса: " . mysqli_error($db_connect);
                exit();
            }
        } else {
            echo "Ошибка: ID страницы не указан.";
            exit();
        }
    } elseif ($_SERVER["REQUEST_METHOD"] == "GET" && $action == 'modules/events/edit') {
        // Обработка GET-запроса для отображения страницы редактирования
        if (isset($_GET['id'])) {
            require_once ENGINE_DIR.'/mods/get_module_categories.php';

            $page_id = $_GET['id'];
            // Подключаем дополнительные поля
            require_once(SYSTEM_DIR . '/plugins/extra_fields.php');
            $stmt = $db_connect->select("events", "*", ["id" => $page_id]);

            if ($stmt) {
                $result = $stmt;
                if ($result) {
                    $page = $result[0];
                    $smarty->assign('page', $page);
                    $selectedCategories = getCategoriesIds($page["id"], "events");
                    $smarty->assign('selectedCategories', $selectedCategories);

                    $selectedLanguages = explode(", ", $page['language']);
                    $smarty->assign('selectedLanguages', $selectedLanguages);
                } else {
                    echo "Ошибка: Страница не найдена.";
                    exit();
                }
            } else {
                // В случае ошибки выводим сообщение
                echo "Ошибка подготовки запроса: " . mysqli_error($db_connect);
                exit();
            }
        } else {
            // Если запрос не был отправлен методом GET или отсутствует параметр id, выводим сообщение об ошибке
            echo "Ошибка: Доступ запрещен.";
            exit();
        }
    }

    // Устанавливаем массив переменных в Smarty
    $smarty->assign('categories', $categories);
    $smarty->assign('add_page', 'add_page');
    $smarty->assign('page_id', $page_id);
    $smarty->assign('stmt', $stmt);
    $yourData = array('title' => $lang['nav']['eventsedit'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active"><a href="/admin?action=events/list">Мероприятия</a></li>
        <li class="breadcrumb-item active">Редактирование мероприятия</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);