<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

// Подключение конфигурации и Medoo
require_once ENGINE_DIR . '/data/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Удаление участника
    if (!empty($_POST['delete_participants_id'])) {
        $participants_id = (int) $_POST['delete_participants_id'];

        $db_connect->delete("event_participants", [
            "id" => $participants_id
        ]);

        header("Location: " . $_SERVER['REQUEST_URI']);
        exit();
    }

    // Обновление участника
    if (!empty($_POST['participant_id'])) {
        $participant_id = (int) $_POST['participant_id'];

        $username    = trim($_POST['username'] ?? '');
        $phone       = trim($_POST['phone'] ?? '');
        $social_url  = trim($_POST['social_url'] ?? '');
        $status      = trim($_POST['status'] ?? '');
        $notes       = trim($_POST['notes'] ?? '');
        $event_title = trim($_POST['event_title'] ?? '');

        if ($participant_id > 0 && $username !== '' && $phone !== '') {
            $db_connect->update("event_participants", [
                "username"    => $username,
                "phone"       => $phone,
                "social_url"  => $social_url,
                "status"      => $status,
                "notes"       => $notes,
                "event_title" => $event_title
            ], [
                "id" => $participant_id
            ]);

            header("Location: " . $_SERVER['REQUEST_URI']);
            exit();
        } else {
            echo 'Некорректные данные участника.';
        }
    }
}

// Получение всех участников, новые сверху
$event_participants = $db_connect->select("event_participants", "*", [
    "ORDER" => ["registration_date" => "DESC"]
]);

$smarty->assign('event_participants', $event_participants);

$yourData = [
    'title' => $lang['nav']['participantsrequests'] . ' - ' . $config['title']
];
$smarty->assign('data', $yourData);
$smarty->assign('page_name', '
    <li class="breadcrumb-item active">' . $lang['nav']['participantsrequests'] . '</li>
');
$smarty->assign('theme', SYSTEM_DIR);
$smarty->assign('config', $config);
