<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    $module_entity = 'files';

    // Сбрасываем счетчик автоинкремента к максимальному значению id
    require_once(ENGINE_DIR . '/mods/autoincrement.php');
   // list($page_id, $max_id) = resetAutoIncrement($db_connect, $module_entity);

    // Подключаем файл проверки зарезервированных URL и запрещённых символов
    require_once(SYSTEM_DIR . '/plugins/reserved_urls.php');

    // Получаем категории
    $categories = [];
    $result = $db_connect->select("files_categories", "*") ?? [];
    foreach ($result as $row) {
        $categories[] = $row;
    }
    // Инициализация сообщения об ошибке
    $error_message = '';

    // Обработка формы добавления файла
    if (isset($_POST['addfile'])) {
        $folder = $_POST['folder'] ?? '';
        $p_id = (int)$db_connect->max("files", "id") + 1;
        
        // Подготовка запроса на добавление в таблицу files_field_values
        $x_values = isset($_POST['x_value']) ? implode(', ', $_POST['x_value']) : '';
        $field_ids = $_POST['field_ids'] ?? [];
        $files_id = $p_id;
        
        // Проверка загруженного файла (не в редакторе)
        require_once(ENGINE_DIR . '/mods/check_upload_file.php');
        
        // Проверка загруженного изображения (не в редакторе)
        require_once(ENGINE_DIR . '/mods/check_upload_image.php');
    
        // Получаем данные из формы, заполняя недостающие поля значениями по умолчанию
        $autor = isset($_POST['autor']) ? strip_tags(trim($_POST['autor'])) : '';
        $date = isset($_POST['date']) && !empty($_POST['date']) ? strip_tags(trim($_POST['date'])) : date($config['date_format']);
        $category = isset($_POST['category']) ? (is_array($_POST['category']) ? implode(', ', $_POST['category']) : $_POST['category']) : '';
        $language = isset($_POST['language']) ? (is_array($_POST['language']) ? implode(', ', $_POST['language']) : $_POST['language']) : '';
        $title = strip_tags(trim($_POST['title']));
        $alt_name = strip_tags(trim($_POST['alt_name']));
        $short_desc = htmlspecialchars($_POST['short_desc'], ENT_QUOTES);
        $full_desc = htmlspecialchars($_POST['full_desc'], ENT_QUOTES);
        $price = isset($_POST['price']) ? (float)strip_tags(trim($_POST['price'])) : 0.0;
        $version = isset($_POST['version']) ? $_POST['version'] : '';
        $license = isset($_POST['license']) ? $_POST['license'] : '';
        $contact_info = isset($_POST['contact_info']) ? (int)$_POST['contact_info'] : 0;
		$meta_desc = strip_tags(trim($_POST['meta_desc']));
		$meta_keys = strip_tags(trim($_POST['meta_keys']));
        $views = isset($_POST['views']) ? intval($_POST['views']) : 0;

        // Проверяем, были ли загружены файл и изображение
        if (empty($file)) {$error_message .= "Файл не загружен.<br>";}
        if (empty($image)) {$error_message .= "Изображение не загружено.<br>";}
        // Проверяем, содержит ли URL запрещённые символы
        $forbidden_char_found = containsForbiddenChars($alt_name, $reserved_urls['forbidden_chars']); // Проверяем без преобразования в нижний регистр
        if ($forbidden_char_found) {
            // Если найден запрещённый символ, создаём сообщение об ошибке
            $error_message = "Ошибка: URL содержит запрещённый символ: '{$forbidden_char_found}'.";
            $smarty->assign('error_message', $error_message);
        }
        // Преобразуем URL в нижний регистр для проверки на зарезервированные значения
        elseif (array_key_exists(strtolower($alt_name), $reserved_urls)) {
            // Если URL зарезервирован, создаём сообщение об ошибке
            $error_message = "Ошибка: " . $reserved_urls[strtolower($alt_name)];
            $smarty->assign('error_message', $error_message);
        } elseif (empty($error_message)) {
            $db_connect->insert("files", [
                "autor" => $autor,
                "date" => $date,
                "language" => $language,
                "title" => $title,
                "file_path" => $file,
                "image" => $image,
                "alt_name" => $alt_name,
                "short_desc" => $short_desc,
                "full_desc" => $full_desc,
                "price" => $price,
                "version" => $version,
                "license" => $license,
                "contact_info" => $contact_info,
                "views" => $views
            ]);
            $files_id = $db_connect->id();

            if (!empty($_POST["category"])) {
                foreach ($_POST["category"] as $categoryId) {
                    $db_connect->insert("files_cat_relations", [
                        "files_id" => (int)$files_id,
                        "category_id" => (int)$categoryId,
                    ]);
                }
            }


            require_once ENGINE_DIR . '/mods/access_control.php';
            saveAccessSettings((int)$files_id, "files", $_POST["exclude_locations"] ?? [], $_POST["include_locations"] ?? [], $_POST["groups"]);

            if (!empty($field_ids)) {
                foreach ($field_ids as $field_id) {
                    if (!empty($_POST['x_value'][$field_id])) {
                        $insertField = $db_connect->insert("files_field_values", [
                            "files_id" => $files_id,
                            "field_id" => $field_id,
                            "x_value" => $_POST['x_value'][$field_id]
                        ]);
                    }
                }
            }
            // Проверяем результат выполнения запроса
            if ($result) {
                // Перенаправление на ту же страницу после добавления
                header("Location: /admin?action=modules/files/list");
                exit();
            } else {
                $error_message .= "Ошибка при добавлении файла: " . $db_connect->error . "<br>";
            }
        }
    }

    // Подключаем дополнительные поля
    require_once(SYSTEM_DIR . '/plugins/extra_fields.php');
    $groups = $db_connect->select("roles", "*") ?? [];
    $smarty->assign('groups', $groups);

    $lastRow = $db_connect->get("files", ['id'], [
        "ORDER" => ["id" => "DESC"] // Сортировка по убыванию id
    ]);
    $smarty->assign('POST', $_POST);
    $_POST = [];
    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['nav']['addfiles'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active"><a href="/admin?action=files/list">Файлы</a></li>
        <li class="breadcrumb-item active">' . $lang['nav']['addfiles'] . '</li>
    ');
    $smarty->assign('add_page', 'add_page');
	$smarty->assign('page_id', $lastRow["id"] ?? 0 + 1);
    $smarty->assign('max_id', 0 + 1);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);
    $smarty->assign('categories', $categories);
    $smarty->assign('error_message', $error_message);