<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    // Проверка, была ли отправлена форма для удаления страницы
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_page_id'])) {
        $page_id = $_POST['delete_page_id'];

        // Выполняем запрос для удаления страницы с использованием Medoo
        $db_connect->delete('files', [
            'id' => $page_id
        ]);

        header("Location: /admin?action=modules/files/list");
        exit();
    }

    // Выполняем запрос для получения полного списка объявлений с использованием Medoo
    $files = $db_connect->select('files', '*');

    // Получаем alt_names для каждой категории и формируем ассоциативный массив
    $categoriesAltNames = [];
    $categories = $db_connect->select('files_categories', ['name', 'alt_name']);
    foreach ($categories as $category) {
        $categoriesAltNames[$category['name']] = $category['alt_name'];
    }
    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });

    require_once ENGINE_DIR . '/mods/get_module_categories.php';

    // Формируем данные для отображения
    foreach ($files as &$file) {
        $file[$lang["datatable"]['category']] = getCategoriesString($file['id'], "files");

        $file[$lang["datatable"]["date"]] = $file["date"];
        $file[$lang["datatable"]["author"]] = $file["autor"];
        $file[$lang["datatable"]["views"]] = $file["views"];

        $file[$lang["datatable"]["title"]] = "<a target='_blank' href='/files/{$file['alt_name']}?lang={$file['language']}'>" . $file["title"] . "</a>";
        $file[$lang["datatable"]["lang"]] = "<img src='/engine/lang/{$file['language']}/icon.png' style='height: 22px;' alt=''>";
        $file[$lang["datatable"]["actions"]] = "<a href='/admin?action=modules/files/edit&id={$file['id']}' class='mx-1 top-1'><i class='fa fa-edit'></i></a>
                                <form method='POST' action='/admin?action=modules/files/list' style='display:inline;'>
                                    <input type='hidden' name='delete_page_id' value='{$file['id']}'>
                                    <button type='submit' class='no-b mx-1' onclick='return confirm(`Вы уверены, что хотите удалить этот файл?`);'>
                                        <i class='fa fa-trash'></i>
                                    </button>
                                </form>";
    }

    // Устанавливаем массив переменных в Smarty
    $smarty->assign('files', $files);
    $yourData = array('title' => $lang['nav']['fileslist'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
            <li class="breadcrumb-item active">' . $lang['nav']['fileslist'] . '</li>
        ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);
?>
