<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    $module_entity = 'lots';

    $action = isset($_GET['action']) ? $_GET['action'] : 'main';

    // Запрос к базе данных для получения данных категорий
    $query_categories = "SELECT * FROM lots_categories";
    $result_categories = mysqli_query($db_connect, $query_categories);

    // Проверка успешности выполнения запроса
    if ($result_categories) {
        // Преобразование результата запроса в ассоциативный массив
        $categories = mysqli_fetch_all($result_categories, MYSQLI_ASSOC);
        
        // Передача массива категорий в шаблон
        $smarty->assign('categories', $categories);
    } else {
        // Если произошла ошибка при выполнении запроса
        echo "Ошибка выполнения запроса категорий: " . mysqli_error($db_connect);
        exit();
    }

    if ($_SERVER["REQUEST_METHOD"] == "POST" && $action == 'lots/edit') {
        // Обработка POST-запроса для сохранения изменений страницы
        if (isset($_POST['page_id'])) {
            $page_id = $_POST['page_id'];
            $folder = $_POST['folder'] ?? '';
            $p_id = $_POST['p_id'] ?? '';
        
            // Подготовка запроса на добавление в таблицу lots_field_values
            $x_values = isset($_POST['x_value']) ? implode(', ', $_POST['x_value']) : '';
            $field_ids = $_POST['field_ids'] ?? [];
            $lots_id = $page_id;

            // Добавляем в базу данные для каждого дополнительного поля
            if (!empty($field_ids)) {
                foreach ($field_ids as $field_id) {
                    // Проверяем, существует ли значение для данного поля
                    if (!empty($_POST['x_value'][$field_id])) {
                        $x_value = $db_connect->real_escape_string($_POST['x_value'][$field_id]);
                        // Выполняем вставку в таблицу
                        $insertField = "INSERT INTO lots_field_values (lots_id, field_id, x_value) 
                                        VALUES ('$lots_id', '$field_id', '$x_value')";
                        if (!$db_connect->query($insertField)) {
                            $error_message .= "Ошибка при добавлении доп. поля с ID $field_id: " . $db_connect->error . "<br>";
                        }
                    }
                }
            }
            
            // Проверка загруженного изображения (не в редакторе)
            require_once(ENGINE_DIR . '/mods/check_upload_image.php');
            
            $date = isset($_POST['date']) && !empty($_POST['date']) ? strip_tags(trim($_POST['date'])) : date($config['date_format']);
            $autor = isset($_POST['autor']) ? strip_tags(trim($_POST['autor'])) : '';
            $category = isset($_POST['category']) ? (is_array($_POST['category']) ? implode(', ', $_POST['category']) : $_POST['category']) : '';
            $language = isset($_POST['language']) ? (is_array($_POST['language']) ? implode(', ', $_POST['language']) : $_POST['language']) : '';
            $title = strip_tags(trim($_POST['title']));
            $alt_name = strip_tags(trim($_POST['alt_name']));
            $short_desc = htmlspecialchars($_POST['short_desc'], ENT_QUOTES);
            $full_desc = htmlspecialchars($_POST['full_desc'], ENT_QUOTES);
            
            $start_date = isset($_POST['start_date']) && !empty($_POST['start_date']) ? strip_tags(trim($_POST['start_date'])) : date($config['date_format']);
            $end_date = isset($_POST['end_date']) && !empty($_POST['end_date']) ? strip_tags(trim($_POST['end_date'])) : date($config['date_format']);
            $location = isset($_POST['location']) ? (is_array($_POST['location']) ? implode(', ', $_POST['location']) : $_POST['location']) : '';
            $capacity = isset($_POST['capacity']) ? (is_array($_POST['capacity']) ? implode(', ', $_POST['capacity']) : $_POST['capacity']) : '';
            $status = isset($_POST['status']) ? (is_array($_POST['status']) ? implode(', ', $_POST['status']) : $_POST['status']) : '';
            $performers = isset($_POST['performers']) ? (is_array($_POST['performers']) ? implode(', ', $_POST['performers']) : $_POST['performers']) : '';
            
            $meta_desc = strip_tags(trim($_POST['meta_desc']));
            $meta_keys = strip_tags(trim($_POST['meta_keys']));
            $views = isset($_POST['views']) ? intval($_POST['views']) : 0;

            $query = "UPDATE lots SET date = ?, autor = ?, category = ?, language = ?, title = ?, alt_name = ?, short_desc = ?, full_desc = ?, start_date = ?, end_date = ?, location = ?, capacity = ?, status = ?, performers = ?, meta_keys = ?, meta_desc = ? WHERE id = ?";
            $stmt = mysqli_prepare($db_connect, $query);
            if ($stmt) {
                mysqli_stmt_bind_param($stmt, "ssssssssssssssssi", $date, $autor, $category, $language, $title, $alt_name, $short_desc, $full_desc, $start_date, $end_date, $location, $capacity, $status, $performers, $meta_keys, $meta_desc, $page_id);
                mysqli_stmt_execute($stmt);
                mysqli_stmt_close($stmt);

                header("Location: /admin?action=lots/list");
                exit();
            } else {
                echo "Ошибка подготовки запроса: " . mysqli_error($db_connect);
                exit();
            }
        } else {
            echo "Ошибка: ID страницы не указан.";
            exit();
        }
    } elseif ($_SERVER["REQUEST_METHOD"] == "GET" && $action == 'lots/edit') {
        // Обработка GET-запроса для отображения страницы редактирования
        if (isset($_GET['id'])) {
            $page_id = $_GET['id'];
            // Подключаем дополнительные поля
            require_once(SYSTEM_DIR . '/plugins/extra_fields.php');
            // Запрос к базе данных для получения данных страницы
            $query = "SELECT * FROM lots WHERE id = ?";
            $stmt = mysqli_prepare($db_connect, $query);

            if ($stmt) {
                mysqli_stmt_bind_param($stmt, "i", $page_id);
                mysqli_stmt_execute($stmt);
                $result = mysqli_stmt_get_result($stmt);

                if ($result && mysqli_num_rows($result) > 0) {
                    // Если страница найдена, передаем данные в шаблон для редактирования
                    $page = mysqli_fetch_assoc($result);
                    $smarty->assign('page', $page);

                    // Разбиваем строку с категориями в массив
                    $selectedCategories = explode(", ", $page['category']);
                    $smarty->assign('selectedCategories', $selectedCategories);

                    // Разбиваем строку с языками в массив
                    $selectedLanguages = explode(", ", $page['language']);
                    $smarty->assign('selectedLanguages', $selectedLanguages);
                } else {
                    // Если страница не найдена, выдаем ошибку
                    echo "Ошибка: Страница не найдена.";
                    exit();
                }

                // Закрываем запрос
                mysqli_stmt_close($stmt);
            } else {
                // В случае ошибки выводим сообщение
                echo "Ошибка подготовки запроса: " . mysqli_error($db_connect);
                exit();
            }
        } else {
            // Если запрос не был отправлен методом GET или отсутствует параметр id, выводим сообщение об ошибке
            echo "Ошибка: Доступ запрещен.";
            exit();
        }
    }

    // Устанавливаем массив переменных в Smarty
    $smarty->assign('add_page', 'add_page');
    $smarty->assign('page_id', $page_id);
    $smarty->assign('stmt', $stmt);
    $yourData = array('title' => $lang['nav']['lotsedit'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active"><a href="/admin?action=lots/list">' . $lang['topmenu']['lots'] . '</a></li>
        <li class="breadcrumb-item active">Редактирование лота</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);