<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    $module_entity = 'movies';

    // Сбрасываем счетчик автоинкремента к максимальному значению id
    require_once(ENGINE_DIR . '/mods/autoincrement.php');
        
    // Подключаем файл проверки зарезервированных URL и запрещённых символов
    require_once(SYSTEM_DIR . '/plugins/reserved_urls.php');

    $categories = [];
    $result = $db_connect->select("movies_categories", "*") ?? [];
    foreach ($result as $row) {
        $categories[] = $row;
    }

    $error_message = '';
    
    // Обработка формы добавления пользователя
    if (isset($_POST['addmovie'])) {
        $folder = $_POST['folder'] ?? '';
        $p_id = (int)$db_connect->max("movies", "id") + 1;
        
        // Подготовка запроса на добавление в таблицу movies_field_values
        $x_values = isset($_POST['x_value']) ? implode(', ', $_POST['x_value']) : '';
        $field_ids = $_POST['field_ids'] ?? [];
        $movies_id = $p_id;
        
        // Проверка загруженного изображения (не в редакторе)
        require_once(ENGINE_DIR . '/mods/check_upload_image.php');
		
		// Получаем данные из формы
        $autor = isset($_POST['autor']) ? strip_tags(trim($_POST['autor'])) : '';
        $date = isset($_POST['date']) && !empty($_POST['date']) ? strip_tags(trim($_POST['date'])) : date($config['date_format']);
        $category = isset($_POST['category']) ? (is_array($_POST['category']) ? implode(', ', $_POST['category']) : $_POST['category']) : '';
        $language = isset($_POST['language']) ? (is_array($_POST['language']) ? implode(', ', $_POST['language']) : $_POST['language']) : '';
        $title = strip_tags(trim($_POST['title']));
        $alt_name = strip_tags(trim($_POST['alt_name']));
        $search_id = strip_tags(trim($_POST['search_id']));
        $year = isset($_POST['year']) ? (is_array($_POST['year']) ? implode(', ', $_POST['year']) : $_POST['year']) : '';
        $quality = isset($_POST['quality']) ? (is_array($_POST['quality']) ? implode(', ', $_POST['quality']) : $_POST['quality']) : '';
        $director = strip_tags(trim($_POST['director']));
        $actors = strip_tags(trim($_POST['actors']));
        $short_desc = htmlspecialchars($_POST['short_desc'], ENT_QUOTES);
		$full_desc = htmlspecialchars($_POST['full_desc'], ENT_QUOTES);
		$meta_desc = strip_tags(trim($_POST['meta_desc']));
		$meta_keys = strip_tags(trim($_POST['meta_keys']));
        $views = isset($_POST['views']) ? intval($_POST['views']) : 0;

        // Проверяем, было ли загружено изображение
        if (empty($image)) {$error_message .= "Изображение не загружено.<br>";}
        // Проверяем, содержит ли URL запрещённые символы
        $forbidden_char_found = containsForbiddenChars($alt_name, $reserved_urls['forbidden_chars']); // Проверяем без преобразования в нижний регистр
        if ($forbidden_char_found) {
            // Если найден запрещённый символ, создаём сообщение об ошибке
            $error_message = "Ошибка: URL содержит запрещённый символ: '{$forbidden_char_found}'.";
            $smarty->assign('error_message', $error_message);
        }
        // Преобразуем URL в нижний регистр для проверки на зарезервированные значения
        elseif (array_key_exists(strtolower($alt_name), $reserved_urls)) {
            // Если URL зарезервирован, создаём сообщение об ошибке
            $error_message = "Ошибка: " . $reserved_urls[strtolower($alt_name)];
            $smarty->assign('error_message', $error_message);
        } elseif (empty($error_message)) {
            $lastRow = $db_connect->max("movies", "id");
            $result = $db_connect->insert("movies", [
                "id" => $lastRow + 1,
                "autor" => $autor,
                "date" => $date,
                "language" => $language,
                "title" => $title,
                "search_id" => $search_id,
                "year" => $year,
                "quality" => $quality,
                "director" => $director,
                "actors" => $actors,
                "short_desc" => $short_desc,
                "full_desc" => $full_desc,
                "meta_desc" => $meta_desc,
                "meta_keys" => $meta_keys,
                "views" => $views,
                "image" => $image
            ]);
            $movies_id = $lastRow + 1;

            if (!empty($_POST["category"])) {
                foreach ($_POST["category"] as $categoryId) {
                    $db_connect->insert("movies_cat_relations", [
                        "movies_id" => (int)$movies_id,
                        "category_id" => (int)$categoryId,
                    ]);
                }
            }

            require_once ENGINE_DIR . '/mods/access_control.php';
            saveAccessSettings((int)$movies_id, "movies", $_POST["exclude_locations"] ?? [], $_POST["include_locations"] ?? [], $_POST["groups"]);

            if (!empty($field_ids)) {
                foreach ($field_ids as $field_id) {
                    if (!empty($_POST['x_value'][$field_id])) {
                        $insertField = $db_connect->insert("movies_field_values", [
                            "movies_id" => $movies_id,
                            "field_id" => $field_id,
                            "x_value" => $_POST['x_value'][$field_id]
                        ]);
                    }
                }
            }
            // Проверяем результат выполнения запроса
            if ($result) {
                // Перенаправление на ту же страницу после добавления
                header("Location: /admin?action=modules/movies/list");
                exit();
            } else {
                $error_message .= "Ошибка при добавлении файла: " . $db_connect->error . "<br>";
            }
        }
    }

    // Подключаем дополнительные поля
    require_once(SYSTEM_DIR . '/plugins/extra_fields.php');
    $groups = $db_connect->select("roles", "*") ?? [];
    $smarty->assign('groups', $groups);

    $lastRow = $db_connect->get("movies", ['id'], [
        "ORDER" => ["id" => "DESC"] // Сортировка по убыванию id
    ]);
    $smarty->assign('POST', $_POST);
    $_POST = [];
    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['nav']['addmovies'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active"><a href="/admin?action=movies/list">Фильмы</a></li>
        <li class="breadcrumb-item active">' . $lang['nav']['addmovies'] . '</li>
    ');
    $smarty->assign('add_page', 'add_page');
	$smarty->assign('page_id', $lastRow["id"] ?? 0 + 1);
    $smarty->assign('max_id', 0 + 1);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);
    $smarty->assign('categories', $categories);
    $smarty->assign('error_message', $error_message);