<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    $module_entity = 'news';

    // Сбрасываем счетчик автоинкремента к максимальному значению id
    require_once(ENGINE_DIR . '/mods/autoincrement.php');
//    list($page_id, $max_id) = resetAutoIncrement($db_connect, $module_entity);

    // Подключаем файл проверки зарезервированных URL и запрещённых символов
    require_once(SYSTEM_DIR . '/plugins/reserved_urls.php');

    $categories = [];
    $result = $db_connect->select("news_categories", "*") ?? [];
    if (!empty($result["id"])) {
        $categories[] = $result;
    } else {
        foreach ($result as $row) {
            $categories[] = $row;
        }
    }

    // Инициализация сообщения об ошибке
    $error_message = '';

    // Обработка формы добавления новости
    if (isset($_POST['addnews'])) {
        $folder = $_POST['folder'] ?? '';
        $p_id = (int)$db_connect->max("news", "id") + 1;

        // Подготовка запроса на добавление в таблицу news_field_values
        $x_values = isset($_POST['x_value']) ? implode(', ', $_POST['x_value']) : '';
        $field_ids = $_POST['field_ids'] ?? [];
        $news_id = $p_id;

        // Проверка загруженного изображения (не в редакторе)
        require_once(ENGINE_DIR . '/mods/check_upload_image.php');
        
        // Получаем данные из формы
        $autor = isset($_POST['autor']) ? strip_tags(trim($_POST['autor'])) : '';
        $date = isset($_POST['date']) && !empty($_POST['date']) ? strip_tags(trim($_POST['date'])) : date($config['date_format']);
        //$category = isset($_POST['category']) ? (is_array($_POST['category']) ? implode(', ', $_POST['category']) : $_POST['category']) : '';
        $language = isset($_POST['language']) ? (is_array($_POST['language']) ? implode(', ', $_POST['language']) : $_POST['language']) : '';
        $title = strip_tags(trim($_POST['title']));
        $alt_name = strip_tags(trim($_POST['alt_name']));
        $short_desc = htmlspecialchars($_POST['short_desc'], ENT_QUOTES);
        $full_desc = htmlspecialchars($_POST['full_desc'], ENT_QUOTES);
        $meta_desc = strip_tags(trim($_POST['meta_desc']));
        $meta_keys = strip_tags(trim($_POST['meta_keys']));
        $views = isset($_POST['views']) ? intval($_POST['views']) : 0;

        // Проверяем, было ли загружено изображение
        if (empty($image)) {$error_message .= "Изображение не загружено.<br>";}
        // Проверяем, содержит ли URL запрещённые символы
        $forbidden_char_found = containsForbiddenChars($alt_name, $reserved_urls['forbidden_chars']); // Проверяем без преобразования в нижний регистр
        if ($forbidden_char_found) {
            // Если найден запрещённый символ, создаём сообщение об ошибке
            $error_message = "Ошибка: URL содержит запрещённый символ: '{$forbidden_char_found}'.";
            $smarty->assign('error_message', $error_message);
        }
        // Преобразуем URL в нижний регистр для проверки на зарезервированные значения
        elseif (array_key_exists(strtolower($alt_name), $reserved_urls)) {
            // Если URL зарезервирован, создаём сообщение об ошибке
            $error_message = "Ошибка: " . $reserved_urls[strtolower($alt_name)];
            $smarty->assign('error_message', $error_message);
        } elseif (empty($error_message)) {
            $result = $db_connect->insert("news", [
                "autor" => $autor,
                "date" => $date,
                //"category" => $category,
                "language" => $language,
                "title" => $title,
                "short_desc" => $short_desc,
                "full_desc" => $full_desc,
                "meta_desc" => $meta_desc,
                "meta_keys" => $meta_keys,
                "views" => $views,
                "alt_name" => $alt_name,
                "image" => $image
            ]);
            $news_id = $db_connect->id();

            if (!empty($_POST["category"])) {
                foreach ($_POST["category"] as $categoryId) {
                    $db_connect->insert("news_cat_relations", [
                        "news_id" => (int)$news_id,
                        "category_id" => (int)$categoryId,
                    ]);
                }
            }


            require_once ENGINE_DIR . '/mods/access_control.php';
            saveAccessSettings((int)$news_id, "news", $_POST["exclude_locations"] ?? [], $_POST["include_locations"] ?? [], $_POST["groups"]);

            if (!empty($field_ids)) {
                foreach ($field_ids as $field_id) {
                    if (!empty($_POST['x_value'][$field_id])) {
                        $insertField = $db_connect->insert("files_field_values", [
                            "files_id" => $news_id,
                            "field_id" => $field_id,
                            "x_value" => $_POST['x_value'][$field_id]
                        ]);
                    }
                }
            }
            // Проверяем результат выполнения запроса
            if ($result) {
                // Перенаправление на ту же страницу после добавления
                header("Location: /admin?action=modules/news/list");
                exit();
            } else {
                $error_message .= "Ошибка при добавлении файла: " . $db_connect->error . "<br>";
            }
        }
    }

    // Подключаем дополнительные поля
    require_once(SYSTEM_DIR . '/plugins/extra_fields.php');

    $groups = $db_connect->select("roles", "*") ?? [];
    $smarty->assign('groups', $groups);

    $lastRow = $db_connect->get("news", ['id'], [
        "ORDER" => ["id" => "DESC"] // Сортировка по убыванию id
    ]);
    $smarty->assign('POST', $_POST);
    $_POST = [];
    // Устанавливаем массив переменных в Smarty
    $yourData = array('title' => $lang['nav']['addnews'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active"><a href="/admin?action=news/list">Новости</a></li>
        <li class="breadcrumb-item active">' . $lang['nav']['addnews'] . '</li>
    ');
    $smarty->assign('add_page', 'add_page');
    $smarty->assign('page_id', $lastRow["id"] ?? 0 + 1);
    $smarty->assign('max_id', 0 + 1);
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);
    $smarty->assign('categories', $categories);
    $smarty->assign('error_message', $error_message);