<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    // Проверка, была ли отправлена форма для удаления страницы
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_page_id'])) {
        $page_id = $_POST['delete_page_id'];

        // Выполняем запрос для удаления страницы с использованием Medoo
        $db_connect->delete('news', [
            'id' => $page_id
        ]);

        header("Location: /admin?action=modules/news/list");
        exit();
    }

    // Выполняем запрос для получения полного списка объявлений с использованием Medoo
    $news = $db_connect->select('news', '*');

    // Получаем alt_names для каждой категории и формируем ассоциативный массив
    $categoriesAltNames = [];
    $categories = $db_connect->select('news_categories', ['name', 'alt_name']);
    foreach ($categories as $category) {
        $categoriesAltNames[$category['name']] = $category['alt_name'];
    }
    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });
    // Формируем данные для отображения
    require_once ENGINE_DIR . '/mods/get_module_categories.php';
    foreach ($news as &$newsAssoc) {
        $newsAssoc[$lang["datatable"]['category']] = getCategoriesString($newsAssoc['id'], "news");

        $newsAssoc[$lang["datatable"]["date"]] = $newsAssoc["date"];
        $newsAssoc[$lang["datatable"]["author"]] = $newsAssoc["autor"];
        $newsAssoc[$lang["datatable"]["views"]] = $newsAssoc["views"];

        $newsAssoc[$lang["datatable"]["title"]] = "<a target='_blank' href='/news/{$newsAssoc['alt_name']}?lang={$newsAssoc['language']}'>" . $newsAssoc["title"] . "</a>";
        $newsAssoc[$lang["datatable"]["lang"]] = "<img src='/engine/lang/{$newsAssoc['language']}/icon.png' style='height: 22px;' alt=''>";
        $newsAssoc[$lang["datatable"]["actions"]] = "<a href='/admin?action=modules/news/edit&id={$newsAssoc['id']}' class='mx-1 top-1'><i class='fa fa-edit'></i></a>
                                <form method='POST' action='/admin?action=modules/news/list' style='display:inline;'>
                                    <input type='hidden' name='delete_page_id' value='{$newsAssoc['id']}'>
                                    <button type='submit' class='no-b mx-1' onclick='return confirm(`Вы уверены, что хотите удалить эту новость?`);'>
                                        <i class='fa fa-trash'></i>
                                    </button>
                                </form>";
    }

    // Устанавливаем массив переменных в Smarty
    $smarty->assign('news', $news);
    $yourData = array('title' => $lang['nav']['newslist'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
            <li class="breadcrumb-item active">' . $lang['nav']['newslist'] . '</li>
        ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);
?>
