<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');
    $module_entity = 'products';

    $action = isset($_GET['action']) ? $_GET['action'] : 'main';

    $categories = [];
    $result = $db_connect->select("products_categories", "*") ?? [];
    if (!empty($result["id"])) {
        $categories[] = $result;
    } else {
        foreach ($result as $row) {
            $categories[] = $row;
        }
    }

    if ($_SERVER["REQUEST_METHOD"] == "POST" && $action == 'modules/products/edit') {
        // Обработка POST-запроса для сохранения изменений страницы
        if (isset($_POST['page_id'])) {
            $page_id = $_POST['page_id'];
            $folder = $_POST['folder'] ?? '';
            $p_id = $_POST['p_id'] ?? '';
        
            // Подготовка запроса на добавление в таблицу products_field_values
            $x_values = isset($_POST['x_value']) ? implode(', ', $_POST['x_value']) : '';
            $field_ids = $_POST['field_ids'] ?? [];
            $products_id = $page_id;

            // Добавляем в базу данные для каждого дополнительного поля
            if (!empty($field_ids)) {
                foreach ($field_ids as $field_id) {
                    if (!empty($_POST['x_value'][$field_id])) {
                        $insertField = $db_connect->insert("events_field_values", [
                            "products_id" => $products_id,
                            "field_id" => $field_id,
                            "x_value" => $_POST['x_value'][$field_id]
                        ]);
                    }
                }
            }

            // Проверка загруженного изображения (не в редакторе)
            require_once(ENGINE_DIR . '/mods/check_upload_image.php');
            
            $autor = isset($_POST['autor']) ? strip_tags(trim($_POST['autor'])) : '';
            $date = isset($_POST['date']) && !empty($_POST['date']) ? strip_tags(trim($_POST['date'])) : date($config['date_format']);
            $category = isset($_POST['category']) ? (is_array($_POST['category']) ? implode(', ', $_POST['category']) : $_POST['category']) : '';
            $language = isset($_POST['language']) ? (is_array($_POST['language']) ? implode(', ', $_POST['language']) : $_POST['language']) : '';
            $title = strip_tags(trim($_POST['title']));
            $alt_name = strip_tags(trim($_POST['alt_name']));
            $short_desc = htmlspecialchars($_POST['short_desc'], ENT_QUOTES);
            $full_desc = htmlspecialchars($_POST['full_desc'], ENT_QUOTES);
            $meta_keys = isset($_POST['meta_keys']) ? strip_tags(trim($_POST['meta_keys'])) : '';
            $meta_desc = isset($_POST['meta_desc']) ? strip_tags(trim($_POST['meta_desc'])) : '';
            $price = isset($_POST['price']) ? (float)strip_tags(trim($_POST['price'])) : 0.0;
            $stock_quantity = isset($_POST['stock_quantity']) ? (int)strip_tags(trim($_POST['stock_quantity'])) : 0;   
            $measure_unit = strip_tags(trim($_POST['measure_unit']));
            $brand = strip_tags(trim($_POST['brand']));
            $model = strip_tags(trim($_POST['model']));
            $sku = strip_tags(trim($_POST['sku']));
            $mass = strip_tags(trim($_POST['mass']));
            $dimensions = strip_tags(trim($_POST['dimensions']));
            $color = strip_tags(trim($_POST['color']));
            $material = strip_tags(trim($_POST['material']));
            $warranty = strip_tags(trim($_POST['warranty']));
            $discount = strip_tags(trim($_POST['discount']));
            $promotion = strip_tags(trim($_POST['promotion']));
            $min_order = strip_tags(trim($_POST['min_order']));
            $views = isset($_POST['views']) ? intval($_POST['views']) : 0;

            $stmt = $db_connect->update("products", [
                "date" => $date,
                "autor" => $autor,
                "language" => $language,
                "title" => $title,
                "image" => $image,
                "alt_name" => $alt_name,
                "short_desc" => $short_desc,
                "full_desc" => $full_desc,
                "meta_keys" => $meta_keys,
                "meta_desc" => $meta_desc,
                "price" => $price,
                "stock_quantity" => $stock_quantity,
                "measure_unit" => $measure_unit,
                "brand" => $brand,
                "model" => $model,
                "sku" => $sku,
                "mass" => $mass,
                "dimensions" => $dimensions,
                "color" => $color,
                "material" => $material,
                "warranty" => $warranty,
                "discount" => $discount == "" ? 0 : $discount,
                "promotion" => $promotion,
                "min_order" => $min_order,
                "views" => $views,
            ], ["id" => $products_id]);

            $db_connect->delete("products_cat_relations", ["products_id" => (int)$products_id]);

            if (!empty($_POST["category"])) {
                foreach ($_POST["category"] as $categoryId) {
                    $db_connect->insert("products_cat_relations", [
                        "products_id" => (int)$products_id,
                        "category_id" => (int)$categoryId,
                    ]);
                }
            }

            if ($stmt) {
                header("Location: /admin?action=modules/products/list");
                exit();
            } else {
                echo "Ошибка подготовки запроса: " . mysqli_error($db_connect);
                exit();
            }

        } else {
            echo "Ошибка: ID страницы не указан.";
            exit();
        }
    } elseif ($_SERVER["REQUEST_METHOD"] == "GET" && $action == 'modules/products/edit') {
        // Обработка GET-запроса для отображения страницы редактирования
        if (isset($_GET['id'])) {
            $page_id = $_GET['id'];
            require_once ENGINE_DIR.'/mods/get_module_categories.php';

            // Подключаем дополнительные поля
            require_once(SYSTEM_DIR . '/plugins/extra_fields.php');
            $stmt = $db_connect->select("products", "*", ["id" => $page_id]);

            if ($stmt) {
                $result = $stmt;
                if ($result) {
                    $page = $result[0];
                    $smarty->assign('page', $page);
                    $selectedCategories = getCategoriesIds($page["id"], "products");
                    $smarty->assign('selectedCategories', $selectedCategories);

                    $selectedLanguages = explode(", ", $page['language']);
                    $smarty->assign('selectedLanguages', $selectedLanguages);
                } else {
                    echo "Ошибка: Страница не найдена.";
                    exit();
                }
            } else {
                // В случае ошибки выводим сообщение
                echo "Ошибка подготовки запроса: " . mysqli_error($db_connect);
                exit();
            }
        } else {
            // Если запрос не был отправлен методом GET или отсутствует параметр id, выводим сообщение об ошибке
            echo "Ошибка: Доступ запрещен.";
            exit();
        }
    }

    // Устанавливаем массив переменных в Smarty
    $smarty->assign('categories', $categories);
    $smarty->assign('add_page', 'add_page');
    $smarty->assign('page_id', $page_id);
    $smarty->assign('stmt', $stmt);
    $yourData = array('title' => $lang['nav']['productsedit'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
        <li class="breadcrumb-item active"><a href="/admin?action=products/list">Товары</a></li>
        <li class="breadcrumb-item active">Редактирование товара</li>
    ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);