<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Путь к config.php относительно текущего файла
    require_once(ENGINE_DIR . '/data/config.php');

    // Проверка, была ли отправлена форма для удаления страницы
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_page_id'])) {
        $page_id = $_POST['delete_page_id'];

        // Выполняем запрос для удаления страницы с использованием Medoo
        $db_connect->delete('products', [
            'id' => $page_id
        ]);

        header("Location: /admin?action=modules/products/list");
        exit();
    }

    // Выполняем запрос для получения полного списка объявлений с использованием Medoo
    $products = $db_connect->select('products', '*');

    // Получаем alt_names для каждой категории и формируем ассоциативный массив
    $categoriesAltNames = [];
    $categories = $db_connect->select('products_categories', ['name', 'alt_name']);
    foreach ($categories as $category) {
        $categoriesAltNames[$category['name']] = $category['alt_name'];
    }
    $smarty->registerPlugin('modifier', 'json_encode', function($value) {
        return json_encode($value);
    });

    require_once ENGINE_DIR . '/mods/get_module_categories.php';

    // Формируем данные для отображения
    foreach ($products as &$product) {
        $product[$lang["datatable"]['category']] = getCategoriesString($product['id'], "products") ?? "";

        $product[$lang["datatable"]["date"]] = $product["date"];
        $product[$lang["datatable"]["author"]] = $product["autor"];
        $product[$lang["datatable"]["views"]] = $product["views"];

        $product[$lang["datatable"]["title"]] = "<a target='_blank' href='/products/{$product['alt_name']}?lang={$product['language']}'>" . $product["title"] . "</a>";
        $product[$lang["datatable"]["lang"]] = "<img src='/engine/lang/{$product['language']}/icon.png' style='height: 22px;' alt=''>";
        $product[$lang["datatable"]["actions"]] = "<a href='/admin?action=modules/products/edit&id={$product['id']}' class='mx-1 top-1'><i class='fa fa-edit'></i></a>
                                <form method='POST' action='/admin?action=modules/products/list' style='display:inline;'>
                                    <input type='hidden' name='delete_page_id' value='{$product['id']}'>
                                    <button type='submit' class='no-b mx-1' onclick='return confirm(`Вы уверены, что хотите удалить этот товар?`);'>
                                        <i class='fa fa-trash'></i>
                                    </button>
                                </form>";
    }

    // Устанавливаем массив переменных в Smarty
    $smarty->assign('products', $products);
    $yourData = array('title' => $lang['nav']['productslist'] . ' - ' . $config['title']);
    $smarty->assign('data', $yourData);
    $smarty->assign('page_name', '
            <li class="breadcrumb-item active">' . $lang['nav']['productslist'] . '</li>
        ');
    $smarty->assign('theme', SYSTEM_DIR);
    $smarty->assign('config', $config);
?>
